/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.dashboardAndReports.PaymentStatisticsFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.paymentstatisticsfilter',
	autoScroll: false,
	frame: false,
	border:false,
	method : 'POST',
	modal: true,
	standardSubmit : false,
	cls: 'panelNoSpace',
	defaults: {
		labelAlign:'top',
		width:226
	},
	items: [{
		xtype:'panel',
		cls:'customSearchPanel',
		plugins : "formlabelrequired",
		width:'100%',
		items:[{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226,
				//allowBlank:false
			},
			items:[{
				xtype: 'customcombobox',
				name: 'paymentStatisticsType',
				itemId: 'paymentStatisticsType',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_STATISTICS_TYPE'),
				store:'feeandpayment.dashboardAndReports.PaymentStatisticsType',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype : 'customcombobox',
				name : 'academicYear',
				itemId: 'academicYear',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
				store : 'program.programDetails.programBatches.PrimaryAcademicStore',
				valueField : 'id',
				displayField : 'yearName',
				allowBlank : true,
				width:226
			}]
			},{	
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width:226,
					//allowBlank:false
			},
			items:[{
				xtype: 'datefield',
				name: 'fromDate',
				itemId:'fromDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'tillDate',
				itemId:'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	},{
		xtype:'panel',
		width:'100%',
		items:[{
			xtype:'panel',
			title: getFeeAndPaymentCommonTranslation('SUMMARY'),
			itemId:'paymentstatisticssTabpaneltwo',
			plain: true,
			autoScroll: true,
			hidden:true,
			style:{overflow:'hidden !important',margin:'0!important'}, 
			frame: false,
			border:true,
			name:'tabPanels',
			//items : [{
			//xtype:'panel',
			//title: getFeeAndPaymentCommonTranslation('SUMMARY'),
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '100%',
				defaults: {
					padding: 5,
					flex: 1
				},
				items:[{
					xtype: 'panel',
					itemId: 'feechartpanelsbyacademiestwo',
					layout: 'fit',
					items: [{
						xtype: 'paymentstatisticspiechart',
						itemId: 'paymentstatisticsbyacademiescharttwo',
						title: 'Graph 1',
						//width : '100%',
						//height: 200,
						minHeight : 200,
						minWidth: 200,
						//margin: '0 0 0 10',
						store: 'Academia.store.feeandpayment.dashboardAndReports.FeeStaticCollectionHeadWiseAllAcademy',
						numericField: 'AMOUNT',
						categoryField: 'ACADEMY_NAME'
					}, {
						xtype: 'displayfield',
						name: 'emptylabelbyacademies'
					}]
				}, {
					xtype: 'panel',
					itemId: 'feechartpanelbylocationtwo',
					layout: 'fit',
					items: [{
						xtype: 'paymentstatisticspiechart',
						itemId: 'paymentstatisticsbylocationcharttwo',
						title: 'Graph 2',
						//width : 300,
						//height: 200,
						minHeight : 200,
						minWidth: 200,
						store: 'Academia.store.feeandpayment.dashboardAndReports.FeeStaticCollectionHeadWiseAllLocation',
						numericField: 'AMOUNT',
						categoryField: 'LOCATION_NAME'
					}, {
						xtype: 'displayfield',
						name: 'emptylabelbylocationchart'
					}]
				}]
			}]
		}]
	}]
});