/**
 * Amit G
 */
Ext.define('Academia.view.feeandpayment.discounts.ViewSettledDiscount', {
	extend: 'Ext.window.Window',
	alias: 'widget.viewsettleddiscount',
	modal: true,
	//autoScroll:true,
	title:getFeeAndPaymentCommonTranslation('VIEW_DISCOUNTS'),
	frame: true,
	overflowX: 'hidden',
	overflowY: 'auto',
	modal:true,
	id:'viewsettleddiscountItemId',
	method: 'POST',
	maxHeight:500,
	width: '60%',
	height:'70%',
	padding:'10 10 10 10',
	items: [{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top'
		},
		items: [{
			xtype:'displayfield',
			name:'dicountType',
			itemId:'dicountType',
			style:{marginLeft:'13px'},
			fieldLabel:getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE')
		},{
			xtype: 'displayfield',
			name: 'studentCode',
			itemId:'studentCode',
			style:{marginLeft:'13px'},
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
		}]
	},{
		xtype: 'container',
		layout: 'fit',
		flex: 1,
		margin: '10 0 0 10', 
		items: [{
			xtype: 'grid',
			autoScroll:true,
			name:'viewDiscountGrid',
			itemId:'viewDiscountGridItemId',
			frame:false,
			border:true,
			style:{marginLeft:'10px'
				},
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			store: 'feeandpayment.discount.ViewSettledDiscountStore',
			//maxHeight:300,
			hideHeaders :false,
			selModel: {
				checkOnly : true, 
				allowDeselect: false
			},
			dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'feeandpayment.discount.ViewSettledDiscountStore',
					emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}],
			features: [{
				ftype: 'summary',
				showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			columns: [{
				header: getFeeAndPaymentCommonTranslation('BILL_ID'),
				dataIndex: 'billNo',
				flex:.1,
				renderer: function(value, metaData, record, rowIndex, colIndex, view) {
					metaData.style = "white-space: normal;";
					return value;
				},
				summaryRenderer: function(value, summaryData, dataIndex) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				},
				sortable: true
			}, {
				header: getFeeAndPaymentCommonTranslation('BILL_TYPE'),
				dataIndex: 'raiseBillType',
				flex:.1,
				renderer:function(value, metaData, record, rowIndex, colIndex, view){
					metaData.style = "white-space: normal;";
					return getCommonTranslation(value);
				}
			},{
				header: getFeeAndPaymentCommonTranslation('BILL_DATE'),
				dataIndex: 'billDate',
				flex:.1,
				renderer: function(date) {
					return dateRender(date);
				}
			},{
				header: getFeeAndPaymentCommonTranslation('BILL_AMOUNT'),
				dataIndex: 'billAmount',
				flex:.1,
				summaryType: 'sum',
				summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
					if(!isNullOrEmpty(value)){
						return currencyRenderer(value,store.data.items[0].data.billCurrencyId);
					}
				}/*,
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(record.get("currencyId"))){
						return currencyRenderer(value,record.get("currencyId"));
					}
				}	*/
			},{
				header: getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
				dataIndex: 'discountAmount',
				flex:.1,
				summaryType: 'sum',
				/*renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(record.get("currencyId"))){
						return currencyRenderer(value,record.get("currencyId"));
					}
				},*/
				summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
					if(!isNullOrEmpty(value)){
						return currencyRenderer(value,store.data.items[0].data.discountCurrencyId);
					}
				}

			},{
				header: getFeeAndPaymentCommonTranslation('DISCOUNT_BILL_ID'),
				dataIndex: 'discountBillNo',
				flex:.1
				
			}]
		}]
	}]
});