/**
 *  @author Deepak Nigam
 */

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});

Ext.define('Academia.view.feeandpayment.feerequest.StudentFeeReqBillWaiverGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentfeereqbillwaivergrid',
	store : 'feeandpayment.feerequest.FeeConcessionDetails',
	border: true,
	title : getFeeAndPaymentCommonTranslation('LIST_OF_FEE_REQUEST'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.feerequest.FeeConcessionDetails',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnRaiseRequest',
		text:getCommonTranslation('RAISE_REQUEST'),
		tooltip: getCommonTranslation('RAISE_REQUEST'),
		//glyph: ICONGLYPH.ADDGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'code',
		flex:1,
		hidden:true
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('DISCOUNT_ALREADY_GIVEN'),
		dataIndex : 'discountAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT_WAIVER_REQUESTED'),
		dataIndex : 'waiverAmountRequested',
		flex : 1,
		editor : {
			xtype:'numberfield',
			name: 'waiverAmountRequested',
			itemId:'waiverAmountRequested',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls='gridInputCustomStyle';
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_REQUEST'),
		dataIndex : 'installmentRequest',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">Request</a>';
		}
	},{
		header : getFeeAndPaymentCommonTranslation('REMARK'),
		dataIndex : 'remark',
		flex : 1,
		editor : {
			xtype:'textarea',
			name: 'remark',
			itemId:'remark',
			height:40
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)){
				return value;
			} else {
				meta.tdCls='gridInputCustomStyle';
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}
		}
	}],
	plugins: [cellEditing]
});