/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.managebill.BillFeeHeadsDetailsList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.billfeeheadsdetailslist',
	//store : 'feeandpayment.managebill.FeeStageConfigHead',
	border: true,
	selType:'checkboxmodel',
	cls:'horizontal-scrolling-fix', 
	style:{overflow:'hidden !important',margin:'0!important'}, 
	autoScroll: false,
	/*viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},*/
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners : {
			beforeedit:function( editor, context, e){ 
				if (context.record.get("whetherProrataBilling")==true) {
					return true;
				}else{
					return false;
				}
			}    
		}     
	}],
	initComponent: function() {
		var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
           /* dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]*/
        });
        this.callParent(arguments);
	},
	buildStore: function() {
        return Ext.create('Academia.store.feeandpayment.managebill.FeeStageConfigHead');
    },
    features: [{
    	id: 'group',
    	ftype: 'groupingsummary',
    	groupHeaderTpl: '{name}',
    	hideGroupedHeader: false,
    	enableGroupingMenu: false,
    	showSummaryRow : false
    }],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHead',
		flex:3,
		renderer:function(value){
			if(value!=null){
				return value.value;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
		dataIndex : 'feeAmount',
		flex:2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			return currencyRenderer(value,record.get("currencyId"));
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CONCESSION_AMOUNT'),
		dataIndex : 'concessionAmount',
		flex:2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			return currencyRenderer(value,record.get("currencyId"));
		}
	},{
		header : getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex : 'discountAmount',
		flex:2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			return currencyRenderer(value,record.get("currencyId"));
		}
	},{
		header : getFeeAndPaymentCommonTranslation('NET_AMOUNT'),
		dataIndex : 'netAmount',
		flex:2,
		editor : {
			xtype:'numberfield',
			name: 'netAmount',
			itemId:'netAmount',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
//			enforceMaxLength:true,
			maxLength:16,
			minValue:0,
			validator: function(val) {
//				return;
				var validNumber = new RegExp(/^\d*\.?\d*$/);
				if (validNumber.test(val)) {
					var formValid = Ext.ComponentQuery.query('billheaderwin')[0].down('form')
					formValid.down('#SubmitBtn').setDisabled(false);
//					this.setValue(val);
					return true;
				}else {
					return;
				} 
				this.clearInvalid()
			},
//			listeners:{
//				afterChange: function(obj, val) {
//					var formValid = Ext.ComponentQuery.query('billheaderwin')[0].down('form')
//					if(formValid.isValid()) {
//						formValid.down('#SubmitBtn').setDisabled(false);
////						return;
//					}
////					debugger
//				}
//			}
		},
		renderer:function(value, metaData, record, row, col, store, gridView){
			return value.toString();
			//return BigInt(value).toString();
		//	return currencyRenderer(value,record.get("currencyId"));
			/* var proaRateBilling = record.get("whetherProrataBilling");
			  console.log('proaRateBilling',proaRateBilling);*/

			/* if(!isNullOrEmpty(value)) {
	                return value;
	          } else {
	        	  	meta.tdCls = 'gridInputCustomStyle'; 
	        	  	return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
	          }  */                      
		},
	},{
		header : getFeeAndPaymentCommonTranslation('NO_OF_PARTICIPANT'),
		dataIndex : 'noOfConfiguration',
		hidden:true
	},{
		header : getFeeAndPaymentCommonTranslation('NO_OF_SESSION_COVERED'),
		dataIndex : 'noOfSession',
		hidden:true
	}]

});
