/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.managebill.BillHeaderWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.billheaderwin',
	title:getFeeAndPaymentCommonTranslation('BILL_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 400,
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'billheaderform',
		bodyPadding: '0 0 0 0',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'customcombobox',
			name: 'admissionId',
			itemId:'admissionId',
			width:226,
			fieldLabel: getFeeAndPaymentCommonTranslation('ADMISSION_ID'),
			store: 'feeandpayment.managebill.BillAdmissionID',
			valueField: 'id',
			hidden:true,
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'checkboxfield',
			width: 226,
			boxLabel: getFeeAndPaymentCommonTranslation('CREADIT_NOTE_DEFINITION_TYPE_LABEL'),
            labelAlign: 'left',
            name: 'creditNoteDeff',
            itemId:'creditNoteDeffId',
            inputValue : true,
            uncheckedValue: false ,
			
		}, { 
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width:226,
				labelAlign: 'top'
			},
			items:[
				{
				xtype: 'customcombobox',
				name: 'feePlanType',
				itemId:'feePlanType',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
				//store: 'feeandpayment.FeePlanTypeStore',
				store:'feeandpayment.FeePlanTypeByBillType',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			},
			{
				xtype: 'customcombobox',
				name: 'scholarship',
				itemId:'scholarshipAwardee',
				fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP_RECEIVED'),
				store:'feeandpayment.managebill.ScholarshipAwardee',
				hidden:true,
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				//allowBlank:false,
				typeAhead:true
			},{
				xtype: 'customcombobox',
				name: 'feePlanNo',
				itemId:'feePlanNo',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NO'),
				store: 'feeandpayment.FeePlan',
				valueField: 'id',
				displayField: 'code',
				typeAhead:true,
				disabled:true,
				allowBlank: false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'feePlanNoSmartSearch',
				itemId:'feePlanNoSmartSearchId',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NO'),
				store: 'feeandpayment.managebill.FeePlanSmartSearchStore',
				hidden:true,
				valueField: 'id',
				displayField: 'value',
				queryParam:'query',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            enableKeyEvents  : 'true',
	            hideTrigger:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            triggerAction: '',
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
			}]
		},{
			xtype:'fieldcontainer',
			itemId:'feeRelatedEditId',
			layout:'hbox',
			defaults: {
				width:226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'feePlanSequence',
				itemId:'feePlanSequenceedit',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_SEQUENCE'),
				store: 'feeandpayment.managebill.BillSequence',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				disabled:true,
				allowBlank:false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'feePlanStage',
				itemId:'feePlanStageedit',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_STAGE'),
				store: 'feeandpayment.managebill.FeePlanStage',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				disabled:true,
				allowBlank:false,
				forceSelection:true
			}]
			/*},{
			xtype:'fieldcontainer',
			itemId:'feeRelatedSaveId',
			layout:'vbox',
			defaults: {
				width:460,
				labelAlign: 'top'
			},
			items:[{
					xtype: 'multiselectcombofield',
				    name: 'feePlanSequence',
				    itemId:'feePlanSequence',
				    fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_SEQUENCE'),
				    store: 'feeandpayment.managebill.BillSequence',
				    valueField: 'id',
				    displayField: 'value',
				    allowBlank: false,
				    typeAhead:true,
				    forceSelection:true
				  },{
					xtype: 'multiselectcombofield',
					name: 'feePlanStage',
					itemId:'feePlanStage',
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_STAGE'),
				    store: 'feeandpayment.managebill.FeePlanStage',
				    valueField: 'id',
				    displayField: 'value',
				    typeAhead:true,
				    allowBlank: false,
				    forceSelection:true
				  }]*/
		},{
			xtype:'fieldcontainer',
			itemId:'feeRelatedCourse',
			layout:'hbox',
			defaults: {
				width:226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseCode',
				itemId:'courseCodeId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store:'feeandpayment.CourseByFeePlan',
				valueField: 'id',
				displayField: 'value',
				hidden:true,
			}]
		},{	  
				xtype:'billfeeheadsdetailslist',
				itemId:'billfeeheadsdetailslist',
				style:{marginTop:'10px',marginLeft:'0px'},
				width:500
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width:226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'groupingFeeHead',
				hidden:true,
				itemId:'groupingFeeHead',
				fieldLabel: getCommonTranslation('FEE_HEAD_GROUP'),
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'feeHead',
				hidden:true,
				itemId:'feeHeadedit',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD'),
				store: 'feeandpayment.managebill.FeeStageConfigHead',
				valueField: 'id',
				displayField: 'feeHeadName',
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'feeAmountRelatedId',
			hidden:true,
			defaults: {
				readOnly:true,
				width:226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				name: 'concessionAmount',
				readOnly:true,
				hidden:true,
				itemId:'concessionAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('CONCESSION_AMOUNT'),
				minValue: 0
			},{
				xtype: 'numberfield',
				name: 'feeAmount',
				itemId:'feeAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
				minValue: 0
			}]   
		},{	
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'amountRelatedId',
			hidden:true,
			defaults: {
				readOnly:true,
				width:226,
				labelAlign: 'top'
			},
			items:[{	
				xtype: 'numberfield',
				name: 'discountAmount',
				itemId:'discountAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
				minValue: 0
			},{
				xtype: 'numberfield',
				name: 'billableAmount',
				itemId:'billableAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('NET_AMOUNT'),
				minValue: 0
			}]   
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'IAUDiscountamountRelatedId',
			hidden:true,
			defaults: {
				labelAlign: 'top',
				width:226,
				readOnly:true
			},
			items:[{	
				xtype: 'textfield',
				name: 'IAUFeesAmount',
				itemId:'IAUFeesAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU_FEES_AMOUNT'),
				hidden:true
			},{
				xtype: 'textfield',
				name: 'IAUDiscount',
				itemId:'IAUDiscount',
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU_DISCOUNT'),
				hidden:true
			}] 
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'configSessionRelatedId',
			hidden:true,
			defaults: {
				readOnly:true,
				width:226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'IAUNetAmount',
				itemId:'IAUNetAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU_NET_AMOUNT'),
				hidden:true
			},{	
				xtype: 'textfield',
				name: 'noOfConfiguration',
				itemId:'noOfConfiguration',
				fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_PARTICIPANT')
			}] 
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'noOfSessionCovered',
			hidden:true,
			defaults: {
				readOnly:true,
				width:226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'noOfSession',
				itemId:'noOfSession',
				fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_SESSION_COVERED')
			}] 
		},{
			xtype:'fieldcontainer',
			// style:{marginTop:'10px'},
			// cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
});