/**
 *  @author Amit G
 */
var offlinePaymentStore='feeandpayment.payment.FeeOfflinePaymentDetailMainGridStore';
Ext.define('Academia.view.feeandpayment.payment.FeeOfflinePaymentDetailMainGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.feeofflinepaymentdetailmaingrid',
	store : offlinePaymentStore,
	title: getCommonTranslation('OFFFLINE_PAYMENT_PROOF_DETAIL'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : offlinePaymentStore,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		text: getFeeAndPaymentCommonTranslation('VIEW'),
		//iconCls: 'view-icon',
		cls: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
	},
	{
		xtype: 'button',
		itemId: 'availablebtnView',
		text: getFeeAndPaymentCommonTranslation('VERIFY_AVAILABLE_AMOUNT'),
		//iconCls: 'view-icon',
		cls: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation.name',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'student.code',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'student.firstName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batch',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('PROOF_NO'),
		dataIndex : 'proofno',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex : 'amount',
		flex:1
	},{
		header : getCommonTranslation('CREATED_ON'),
		dataIndex : 'createdOn',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer: function(value) {
			if(value == 'PENDING'){
				return 'Pending';
			}else if(value == 'APPROVED'){
				return 'Approved';
			}else if(value == 'REJECTED'){
				return 'Rejected';
			}
		}
	},{
		header : getCommonTranslation('RECEIPT_NO'),
		dataIndex : 'receiptNo',
		flex:1
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'noOfDocuments',
		flex:1,
		renderer : function(value){
			if(value>=1){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}

		}
	}]
});
