/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.payment.ManageOfflinePaymentDetailMainForm', {   
	extend:'Academia.view.common.DynamicFieldForm',
	formCode:'ManageReceiptForm',
	alias : 'widget.manageofflinepaymentdetailmainform',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
	method : 'POST',
	title:getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS'),
	frame:true,
	standardSubmit : false,
	defaults: {
		labelAlign:'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'hidden',
			name:'studentId'
		},
		{
			xtype:'hidden',
			name:'applicantId'
		},{
			xtype:'hidden',
			name:'studentCode',
			itemId:'studentCode'
				
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'textfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF_NO'),
				itemId:'offlinePaymentProofNo',
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				name:'offlinePaymentProofNo',
				readOnly:true
			},{
				xtype: 'textfield',
				name: 'receivingCurrency',
				itemId:'receivingCurrency',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
				//store: 'feeandpayment.FeeCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false,
				typeAhead:false,
				readOnly:true,
				forceSelection:true
			}]
		},{
			xtype:'panel',
			itemId: 'offlinePaymentMainheaderPanel',
			style:{margin:'0px'},
			width: '100%',
			items:[{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox',
					align: 'bottom'
				},
				items: [{
					xtype: 'customcombobox',
					itemId: 'paymentMode',
					name: 'paymentMode',
					 width: 135,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
					labelAlign: 'top',
					store: 'feeandpayment.FeePaymentMode',
					valueField: 'id',
					displayField: 'value',
					//typeAhead:true,
				    forceSelection:true,
					allowBlank: false
				}, {
					xtype:'textfield',
					enableKeyEvents : true,
					itemId: 'instrumentsNo',
					labelAlign: 'top',
					width: 130,
					name: 'instrumentsNo',
					maxLength: 40,
					allowBlank: false,
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					listeners:{
						keypress : function(e, t){
							try {
								if (window.event) {
									var charCode = window.event.keyCode;
								}else if (e) {
									var charCode = e.which;
								}else { return true; }

								if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
									return t.preventDefault();
								}
							}
							catch (err) {
								alert(err.Description);
							} 
						}
					}
				},{
					xtype:'datefield',
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
					itemId:'instrumentDate',
					name:'instrumentDate',
					labelAlign: 'top',
					width: 130,
					allowBlank: false,
					maxValue:new Date(),
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
						}
					}
				},{
					xtype: 'numberfield',
					itemId: 'amount',
					fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
					labelAlign: 'top',
					width: 130,
					name: 'amount',
					minValue: 0,
					maxLength:10,
                    allowDecimals:true,
                    allowBlank: false,
		        	hideTrigger:true,
		        	mouseWheelEnabled:false
				},{
					xtype: 'customcombobox',
					itemId: 'drawnOnBank',
					name: 'drawnOnBank',
					fieldLabel: getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
					labelAlign: 'top',
					width: '31%',
					store: 'feeandpayment.receipts.DrawnOnBank',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
 	        	    forceSelection:true,
					allowBlank: false      	  
				},{
					xtype: 'button',
					itemId: 'btnAddOfflinePaymentHeader',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD')
				},{
					xtype:'hidden',
					name:'instrumentId'
				}] 
			}]
		},{
			xtype: 'feeofflinepaymentdocumentlistmaingrid',
			itemId:'feeofflinepaymentdocumentlistmaingridItemId',
			width: '31%',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1

		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('GENERATE_RECEIPT'),
				formBind: true,
				itemId: 'generateReceipt',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('REJECT'),
				itemId: 'rejectBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]}]
});