/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentInstrumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentinstrumentgrid',
	store : 'feeandpayment.payment.PaymentInstrumentTempStore',
	title : getFeeAndPaymentCommonTranslation('INSTUMENT_DETAILS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW  
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
		dataIndex : 'paymentMode',
		flex : 1,
		renderer:function(val){
			if(val){
				return val.value;
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	},{
		header : getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
		dataIndex : 'instrumentNo',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
		dataIndex : 'instrumentDate',
		flex : 1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex : 1,
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}
	},{
    	 header : getFeeAndPaymentCommonTranslation('OUR_BANK_ACCOUNT'),
     	 dataIndex : 'paymentInstrumentBank',
     	 flex : 1,
     	 renderer:function(val){
     		 if(val){
			     return val.value;
     		 }
		 }
     }]
});