/**
 * @author Mohit Chouhan 
 */
Ext.define('Academia.view.feeandpayment.payment.ReceiptSettlementHeadWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.receiptsettlementheadwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '60%',
	width: '80%',
	defaults:{
		width:'100%'
	},
	layout:'vbox',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('ADJUSTMENTS_DETAILS'),
	items : [{
			xtype: 'grid',
			store : 'feeandpayment.payment.BillHeaderAdjustmentDetails',
			autoScroll: true,
			itemId : 'billHeaderGrid',
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			features: [{
				ftype: 'summary',
				showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'feeandpayment.payment.BillHeaderAdjustmentDetails',
					emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}],
			columns: [{
				header : getFeeAndPaymentCommonTranslation('BILL_DATE'),
				dataIndex : 'billingDate',
				flex : 1,
				renderer: function(date) {
					return dateRender(date);
				}
			},{
				header : getFeeAndPaymentCommonTranslation('BILL_NO'),
				dataIndex : 'billNo',
				flex : 1,
				summaryRenderer: function(value, summaryData, dataIndex) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			},{
				header : getFeeAndPaymentCommonTranslation('FEE_HEAD_NAME'),
				dataIndex : 'feeHeadName',
				flex : 1
			}
			,{
				header : getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
				dataIndex : 'feeAmount',
				hidden : true,
				flex : 1,
			//	align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryType: 'sum',
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(record.get("currencyId"))){
						return currencyRenderer(value,record.get("currencyId"));
					}
				},
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return  value;
				}
			}
			,{
				header : getFeeAndPaymentCommonTranslation('BILLABLE_AMOUNT'),
				dataIndex : 'billableAmount',
				flex : 1,
			//	align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryType: 'sum',
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(record.get("currencyId"))){
						return currencyRenderer(value,record.get("currencyId"));
					}
				},
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return  value;
				}
			}
			,{
				header : getFeeAndPaymentCommonTranslation('FEE_ADJUSTMENT_AMOUNT'),
				dataIndex : 'feeAdjustedAmount',
				flex : 1.0,
				//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryType: 'sum',
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(record.get("currencyId"))){
						return currencyRenderer(value,record.get("currencyId"));
					}
				},
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return  value;
				}
			}
			,{
				header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
				dataIndex : 'adjustmentDate',
				flex : 1,
				renderer: function(date) {
					return dateRender(date);
				}
			}] 	

		}]
});
