/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.receipts.MakePaymentWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.makepaymentwin',
	title:getFeeAndPaymentCommonTranslation('COLLECT_PAYMENT'),
	frame: true,
	modal:true,
	autoScroll: true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		 xtype: 'idgeneratorcustomform',
		//xtype: 'idgeneratorformwin',
		//xtype: 'idgeneratorform',
		itemId:'makePaymentReceiptform',
		formCode:'makePaymentForm',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'hidden',
			name: 'billId'
		},{
			xtype: 'hidden',
			name: 'feePlanId'
		}, {
			xtype: 'hidden',
			name: 'stageName'
		}, {
			xtype: 'hidden',
			name: 'feePlanType'
		},{
			xtype: 'hidden',
			name: 'academyLocationId'
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				cls: 'panelNoSpace'
			},
			items:[{
				xtype:'panel',
				items:[{
					xtype: 'radiogroup',
					itemId:'voucherMode',
					width: 250,
					labelAlign:'top',
					fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
					columns: 2,
					vertical: true,
					items: [
					        { boxLabel: getFeeAndPaymentCommonTranslation('BANK_LABEL'), name: 'voucherMode', inputValue: 'BANK',checked:true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('CASH_LABEL'), name: 'voucherMode', inputValue: 'CASH'}
					        ],
					        listeners:{
					        	change:function(obj,newValue,oldValue){
					        		var value = newValue.voucherMode;
					        		var form = obj.up('form');
					        		var receiptPanelOne = form.down("#receiptPanelOne");
					        		var receiptPanelTwo = form.down("#receiptPanelTwo");
					        		var paymentMode = form.down("#paymentMode");
					        		var depositedBank = form.down("#depositedBank");
					        		var depositedCash = form.down("#depositedCash");
					        		var instrumentNo = form.down("#instrumentNo");
					        		var instrumentDate = form.down("#instrumentDate");
					        		var amount = form.down("#amount");
					        		var instrumentBank = form.down("#instrumentBank");
					        		var instrumentAmount = form.down("#instrumentAmount");
					        		var receiptType = form.down("#receiptType");

					        		receiptPanelOne.setVisible(false);
					        		receiptPanelTwo.setVisible(false);
					        		instrumentAmount.setVisible(false);
					        		depositedBank.setVisible(false);
					        		depositedCash.setVisible(false);
					        		instrumentAmount.allowBlank=true;
					        		paymentMode.allowBlank=true;
					        		instrumentNo.allowBlank=true;
					        		instrumentDate.allowBlank=true;
					        		amount.allowBlank=true;	
					        		instrumentBank.allowBlank=true;

					        		if(value=='CASH'){
					        			instrumentDate.setDisabled(true);
					        			instrumentAmount.setVisible(true);
					        			instrumentAmount.setDisabled(false);
					        			depositedCash.setVisible(true);
					        			depositedCash.setDisabled(false);
					        			receiptType.setVisible(false);
					        			instrumentAmount.allowBlank=false;
					        			instrumentAmount.setFieldLabel(getFeeAndPaymentCommonTranslation('AMOUNT')+'<span class="required" style="color:red"> *</span>');
					        		}else{
					        			instrumentDate.setDisabled(false);
					        			receiptType.setVisible(true);
					        			receiptPanelOne.setVisible(true);
					        			receiptPanelTwo.setVisible(true);
					        			depositedBank.setVisible(true);
					        			paymentMode.allowBlank=false;
					        			instrumentNo.allowBlank=false;
					        			instrumentDate.allowBlank=false;
					        			amount.allowBlank=false;	
					        			instrumentBank.allowBlank=false;
					        		}
					        		form.getForm().checkValidity();
					        	}
					        }
				}]
			},{
				xtype:'panel',
				items:[{
					xtype: 'radiogroup',
					itemId:'receiptType',
					width: 250,
					labelAlign:'top',
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_TYPE'),
					columns: 2,
					vertical: true,
					items: [
					        { boxLabel: getFeeAndPaymentCommonTranslation('REGULAR_LABEL'), name: 'receiptType', inputValue: 'REGULAR',checked:true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('PDC'), name: 'receiptType', inputValue: 'PDC'}
					        ],
			        listeners:{
			        	change:function(obj,newValue,oldValue){
			        		var value = newValue.receiptType;
			        		var form = obj.up('form');
			        		var instrumentDate = form.down("#instrumentDate");
			        		instrumentDate.reset();
			        		if(value=='PDC'){
			        			var date = new Date();
			        			date.setDate(date.getDate() + 1);
			        			instrumentDate.setMinValue(date);
			        			instrumentDate.setValue(date);
			        		}else{
			        			instrumentDate.setMinValue(false);
			        			var value = new Date();
			        			instrumentDate.setValue(value);
			        		}
			        		
			        	}
			        }
				}]
			}]
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'textfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
				itemId:'receiptNo',
				name:'receiptNo',
				allowBlank:true
			},{
				xtype: 'customcombobox',
				name: 'raiseBillType',
				itemId:'billType',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_TYPE'),
				store: 'feeandpayment.managebill.BillType',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				listeners:{
					/*select : function(combo,record){
						combo.nextSibling().clearValue();
						var raiseBillType = record[0].get("id");
						var store = combo.nextSibling().getStore();
						store.getProxy().extraParams = {
							raiseBillType: raiseBillType
						};
						store.load();
					},*/
					render: function(combo) {
						combo.getStore().load();
					}
				}
			},{
				xtype: 'nestedJsonCombo',
				name: 'receiptFor',
				itemId:'receiptForm',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_FORM'),
				store: 'feeandpayment.managebill.BillFor',
				valueField: 'id',
				displayField: 'value',
				//queryMode: 'local',
				//typeAhead:true,
				//forceSelection:true,
				allowBlank:false
			}]
		},{	
			xtype:'fieldcontainer',
			//width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'nestedJsonCombo',
				itemId:'receivingIAU',
				name: 'iau',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_IAU'),
				store: 'feeandpayment.ALUnit',
				valueField: 'id',
				displayField: 'value',
				allowBlank:true
			},{
				xtype: 'nestedJsonCombo',
				name: 'currency',
				itemId:'receivingCurrency',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
				store: 'feeandpayment.BillCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false
			},{
				xtype: 'nestedJsonCombo',
				name: 'depositedBank',
				itemId:'depositedBank',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEPOSITED_BANK_ACCOUNT'),
				store: 'feeandpayment.receipts.Bank',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'nestedJsonCombo',
				name: 'depositedCash',
				hidden:true,
				itemId:'depositedCash',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEPOSITED_LEDGER'),
				store: 'feeandpayment.receipts.FeeLedgerName',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				disabled: true
			}]
		},{
			xtype:'fieldcontainer',
			//width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
				itemId:'transactionDate',
				allowBlank: false,
				name:'transactionDate',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				//submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				format:CONSTANTS.NEW_SUBMIT_DATE_FORMAT,
//				value:new Date(),
//				minValue : new Date(),
				maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj.setMinValue(false);
						var minDate  = new Date();
						obj = dateFormatRender(obj);						
						obj.setValue(minDate);
						obj.setMinValue(minDate);
						Ext.Ajax.request({
				            type: 'rest',
				            url: SERVERURL.PATH_RECEIPT_SETTING_REST,
				            async:true,
				            method: 'GET',
				            headers: {
				                'Content-Type': 'application/json'
				            },
				            success: function(response) {
				            	if(!isNullOrEmpty(response.responseText)){
				            		var responseText  = Ext.decode(response.responseText);
				            		var minDate  = new Date();
				            		var days = responseText.numberOfDays;
				            		minDate = new Date(minDate.getTime() - (days * 24 * 60 * 60 * 1000));
				            		obj.setMinValue(minDate);
				            	}
				            }
				        });
					}
				}
			},{
				xtype: 'textfield',
				itemId: 'student',
				name: 'applicant',
				displayField: 'value',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT')
			},{
				xtype:'numberfield',
				mouseWheelEnabled:false,
				allowDecimals:true,
				hidden:true,
				hideTrigger:true,
				name:'instrumentAmount',
				fieldLabel:getFeeAndPaymentCommonTranslation('AMOUNT'),
				itemId:'instrumentAmount',
				disabled: true
			}]
		},{
			xtype:'fieldcontainer',
			itemId:'addressDetails',
			layout : 'hbox',
			hidden:true,
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'displayfield',
				name: 'address',
				itemId:'address',
				fieldLabel: getFeeAndPaymentCommonTranslation('ADDRESS')
			},{
				xtype: 'displayfield',
				name: 'emailId',
				itemId:'emailId',
				fieldLabel: getFeeAndPaymentCommonTranslation('EMAIL')
			},{
				xtype:'displayfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('PHONE_NO'),
				itemId:'contactNo',
				name:'contactNo'
			}]
		},{
			xtype: 'fieldcontainer',
			itemId: 'receiptPanelOne',
			layout: 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype: 'customcombobox',
				itemId: 'paymentMode',
				name: 'paymentMode',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
				labelAlign: 'top',
				store: 'feeandpayment.FeePaymentMode',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank: false
			}, {
				xtype: 'textfield',
				enableKeyEvents : true,
				itemId: 'instrumentNo',
				fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
				labelAlign: 'top',
				maxLength:40,
				name: 'instrumentNo',
				allowBlank: false,
				listeners:{
					keypress : function(e, t){
						try {
							if (window.event) {
								var charCode = window.event.keyCode;
							}else if (e) {
								var charCode = e.which;
							}else { return true; }

							if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
								return t.preventDefault();
							}
						}
						catch (err) {
							alert(err.Description);
						} 
					}
				}
			},{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
				itemId:'instrumentDate',
				name:'instrumentDate',
				labelAlign: 'top',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				allowBlank: false,
//				value:new Date()
				maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}] 
		},{
			xtype: 'fieldcontainer',
			itemId: 'receiptPanelTwo',
			layout: 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype: 'numberfield',
				itemId: 'amount',
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
				labelAlign: 'top',
				name: 'amount',
				minValue: 0,
				allowDecimals:true,
				allowBlank: false,
				hideTrigger:true,
				mouseWheelEnabled:false
			},{
				xtype: 'customcombobox',
				itemId: 'instrumentBank',
				name: 'instrumentBank',
				fieldLabel: getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
				labelAlign: 'top',
				store: 'feeandpayment.receipts.DrawnOnBank',
				valueField: 'id',
				displayField: 'value',
				width:460,
				typeAhead:true,
				forceSelection:true,
				allowBlank: false   
			}]	
		},{
			xtype:'numberfield',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hidden:true,
			width:226,
			hideTrigger:true,
			name:'discountAmount',
			fieldLabel:getFeeAndPaymentCommonTranslation('DISCOUNT'),
			itemId:'discountAmount'
		},
		{
			xtype: 'fieldcontainer',
		//	itemId: 'receiptPanelOne',
			layout: 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items: [{
			xtype:'textareafield',
			labelAlign:'top',
			name:'narration',
			width:450,
			fieldLabel:getFeeAndPaymentCommonTranslation('NARRATION'),
			itemId:'narration'
		},{
			xtype: 'customcombobox',
			name: 'costCentre',
			itemId:'costCentre',
			fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
			store: 'feeandpayment.receipts.CostCentreReceipt',
			valueField: 'id',
			displayField: 'value',
			//allowBlank: true,
			//typeAhead:true,
			//forceSelection:true,
		}] 
		},
		{
			xtype:'fieldcontainer',
			width:'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'collectPaymentResetBtn',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE_AND_PRINT'),
				formBind: true,
				itemId: 'SubmitAndPrintMakePaymentBtn',
				//ui: 'CustomBtnThird',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});