/**
 *  @author Rajkumar.patidar
 */

 var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
      clicksToEdit: 1,
      listeners : {
    	beforeedit:function( editor, context, e ){ 
        }
    }
 });
 
Ext.define('Academia.view.feeandpayment.receipts.ManageReceiptList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.managereceiptlist',
	store : 'feeandpayment.receipts.ReceiptPaymentInstrument',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    tbar: [{
    	 xtype: 'button',
         itemId: 'btnAdd',
         text:getFeeAndPaymentCommonTranslation('SAVE'),
         tooltip: getFeeAndPaymentCommonTranslation('ADD')
    },{
    	xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),//More Actions
		menu:[{
			text:getFeeAndPaymentCommonTranslation('ADJUST'),
  		    itemId:'adjustLink'
	         },{
  	    	text:getFeeAndPaymentCommonTranslation('FCFS_AUTO_ADJUST'),
  	  		itemId:'FCFSAutoAdjustLink'
		}],
		listeners: { click: function() { this.showMenu(); } }
    }],
	columns: [{
	        	header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
	     		dataIndex : 'paymentMode',
	     		flex : 1,
	     		editor: {
	     			    xtype: 'customcombobox',
						name: 'paymentMode',
						itemId:'paymentMode',
						store:'feeandpayment.FeePaymentMode',
						valueField: 'value',
						displayField: 'value',
						typeAhead:true,
						forceSelection:true,
						listeners:{
							select:function(obj,record){
								var paymentmodeId = record[0].get("id");
							}
						 }
	    			}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
	        	 dataIndex : 'instrumentNo',
		     	 flex : 1,
		     	 editor : {
					xtype: 'numberfield',
				    name: 'instrumentNo',
				    itemId:'instrumentNo'
				  }
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
		     	 dataIndex : 'instrumentDate',
		     	 flex : 1,
		     	 editor: {
					xtype: 'datefield',
				    name: 'instrumentDate',
				    itemId:'instrumentDate',
				    listeners: {
				    	render: function(field) {
				    		return dateFormatRender(field);
				    	}
				    },
				  //--submitFormat: CONSTANTS.DATE_FORMAT,
		            editable:false     
					},
					renderer:function(date) {
						return dateRender(date);
					}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		     	 dataIndex : 'amount',
		     	 flex : 1,
		     	 editor : {
					xtype: 'numberfield',
				    name: 'amount',
				    itemId:'amount'
				  }
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
		     	 dataIndex : 'instrumentBank',
		     	 flex : 1,
		     	 editor : {
						xtype: 'textfield',
					    name: 'instrumentBank',
					    itemId:'instrumentBank'
					  }
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('PAYMENY_ID'),
		     	 dataIndex : 'paymentmodeId',
		     	 hidden:true,
		     	 editor : {
						xtype: 'textfield',
						readOnly:true,
					    name: 'paymentmodeId',
					    itemId:'paymentmodeId'
					  }
	         }],
	 plugins: [cellEditing]
});