/**
 * @author Deepak Nigam
 */
Ext.define('Academia.view.feeandpayment.reports.DependentFeeCollectionReportGrid',
		{
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.dependentfeecollectionreportgrid',
	store : 'feeandpayment.reports.DependentFeeCollectionReportStore',
	title : getFeeAndPaymentCommonTranslation('DEPENDENT_FEE_COLLECTION_DETAILS'),
	cls:'centerAlignTitle',
	border : true,
	autoScroll : false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW  
	}],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : 'feeandpayment.reports.DependentFeeCollectionReportStore',
			emptyMsg : getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns : [{
		header : getCommonTranslation('RECEIPT_NUMBER'),//getFeeAndPaymentCommonTranslation('COLLECTED_BY_ID'),
		dataIndex : 'receiptNo',
		flex : 1,
		renderer:function(value){
			if(value){
				return  '<a href="#">'+value+'</a>';
			}
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			  if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId && store.data.items[0].data.alSize==1)) {
				  return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
			  } else if(!isNullOrEmpty(store.data.items[0].data.orgCurrencyId && store.data.items[0].data.alSize>=1))
			  {
				  return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.orgCurrencyName+")";
			  }else
			  {
				  return getFeeAndPaymentCommonTranslation('TOTAL');
			  }
		  }
	},{
		header : getCommonTranslation('RECEIPT_DATE'),
		dataIndex : 'receiptDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('ID'),
		dataIndex : 'printId',
		flex : 1
	},{
		header : getCommonTranslation('NAME'),
		dataIndex : 'name',
		flex : 1
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'personFirstName',
		flex : 1,
		hidden: true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'personMiddleName',
		flex : 1,
		hidden: true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'personLastName',
		flex : 1,
		hidden: true
	},{
		header : getCommonTranslation('FEE_HEAD_GROUP'),
		dataIndex : 'groupingFeeHeadName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FEE_HEADS'),
		dataIndex : 'feeHeadName',
		flex : 1
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
		dataIndex : 'currencyExchangeRate',
		flex : 1,
		hidden: true
	},{
		header : getCommonTranslation('AMOUNT'),
		dataIndex : 'feeHeadAmount',
		flex : 1.5,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'feeHeadAmountInALBaseCurrency',
		flex:1.5,
		summaryType: 'sum',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.data.feeHeadAmountInALBaseCurrency)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else
			{
				return "";
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(!isNullOrEmpty(value)){
				var store = this.getStore();
				if(!isNullOrEmpty(store)){
					var arrStoreItems = store.data.items;
					var lastRecord = arrStoreItems[arrStoreItems.length-1];
                	if(!isNullOrEmpty(lastRecord)){
                		return currencyRenderer(value,lastRecord.get("baseCurrencyId"));
                	}else
                	{
                		return "";
                	}
				}
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'feeHeadAmountInOrgCurrency',
		flex:1.5,
		summaryType: 'sum',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.data.feeHeadAmountInOrgCurrency)){
				return currencyRenderer(value,record.get("orgCurrencyId"));
			} else
			{
				return "";
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(!isNullOrEmpty(value)){
				var store = this.getStore();
				if(!isNullOrEmpty(store)){
					var arrStoreItems = store.data.items;
					var lastRecord = arrStoreItems[arrStoreItems.length-1];
                	if(!isNullOrEmpty(lastRecord)){
                		return currencyRenderer(value,lastRecord.get("orgCurrencyId"));
                	}else
                	{
                		return "";
                	}
				}
			}
		}
	},{
		header : getCommonTranslation('DEPENDENT_FEE_HEAD'),
		dataIndex : 'dependentFeeHeadName',
		flex : 1
	},{
		header : getCommonTranslation('FIXED_PERCENTAGE'),
		dataIndex : 'dependentValue',
		flex : 1
	},{
		header : getCommonTranslation('DEPENDENT_FEE_AMOUNT'),
		dataIndex : 'dependentFeeHeadAmount',
		flex : 1.5,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(!isNullOrEmpty(value)){
				var store = this.getStore();
				if(!isNullOrEmpty(store)){
					var arrStoreItems = store.data.items;
					var lastRecord = arrStoreItems[arrStoreItems.length-1];
					if(!isNullOrEmpty(lastRecord.get("baseCurrencyId")) || !isNullOrEmpty(lastRecord.get("orgCurrencyId"))){
						return "";
                	}else
                	{
                		return currencyRenderer(value,lastRecord.get("currencyId"));
                	}
				}
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_DEPENDENT_FEE_AMOUNT'),
		dataIndex : 'dependentFeeHeadAmountInALBaseCurrency',
		flex : 1.5,
		summaryType: 'sum',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(!isNullOrEmpty(value)){
				var store = this.getStore();
				if(!isNullOrEmpty(store)){
					var arrStoreItems = store.data.items;
					var lastRecord = arrStoreItems[arrStoreItems.length-1];
					if(!isNullOrEmpty(lastRecord.get("baseCurrencyId")) || !isNullOrEmpty(lastRecord.get("orgCurrencyId"))){
                		return currencyRenderer(value,lastRecord.get("baseCurrencyId"));
                	}else
                	{
                		return "";
                	}
				}
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_DEPENDENT_FEE_AMOUNT'),
		dataIndex : 'dependentFeeHeadAmountInOrgCurrency',
		flex : 1.5,
		summaryType: 'sum',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("orgCurrencyId"));
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(!isNullOrEmpty(value)){
				var store = this.getStore();
				if(!isNullOrEmpty(store)){
					var arrStoreItems = store.data.items;
					var lastRecord = arrStoreItems[arrStoreItems.length-1];
                	if(!isNullOrEmpty(lastRecord.get("baseCurrencyId")) || !isNullOrEmpty(lastRecord.get("orgCurrencyId"))){
                		return currencyRenderer(value,lastRecord.get("orgCurrencyId"));
                	}else
                	{
                		return "";
                	}
				}
			}
		}
	}]

});
