/**
 * @author nitin
 */
Ext.define('Academia.view.feeandpayment.reports.StudentCollectionReportGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.studentcollectionreportgrid',
	store:'feeandpayment.reports.StudentCollectionReport',
	title: getCommonTranslation('STUDENT_COLLECTION_REPORT'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.reports.StudentCollectionReport',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[{
		header : getCommonTranslation('RECEIPT_NUMBER'),
		dataIndex : 'receiptNo',
		flex:1,
		/*summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}*/
		summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
			if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
				return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
			}
			else {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	},{
		header : getCommonTranslation('RECEIPT_DATE'),
		dataIndex : 'receiptDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('RECEIPT_AMOUNT'),
		dataIndex : 'receiptAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('ADJUSTED_AMOUNT'),
		dataIndex : 'settledAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
		dataIndex : 'currencyExchangeRate',
		flex:1.0,
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},*/
	},{
		header : getCommonTranslation('CONVERTED_RECEIPT_AMOUNT'),
		dataIndex : 'convertedReceiptAmount',
		flex:1.0,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_SETTLED_AMOUNT'),
		dataIndex : 'convertedSettledAmount',
		flex:1.0,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentID',
		flex:1,
		sortable:true,
		renderer:function(value){
			return '<a href=#>'+value+'</a>'
		}
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'printName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'personFirstName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'personMiddleName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'personLastName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FATHER_NAME'),
		dataIndex : 'fatherName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'section',
		flex:1,
		hidden: true
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex:1
	},{
		header : getCommonTranslation('VOUCHER_MODE'),
		dataIndex : 'voucherMode',
		flex:1,
		renderer:function(value){
			if(value == 'CASH')
				return 'Cash';
			else if(value == 'BANK')
				return 'Bank';
		}
	},
	{
		header : getCommonTranslation('PAYMENT_MODE'),
		dataIndex : 'paymentModeName',
		flex:1,
		hidden:true
	},
	{
		header : getCommonTranslation('RECEIPT_STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer:function(value){
			return getCommonTranslation(value)
		}
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'address',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('MOBILE_NUMBER'),
		dataIndex : 'mobileNo',
		flex:1,
		hidden:true
	}]

});
