/*
 * @author sumit meena
 */
Ext.define('Academia.view.gradeMaster.GradeMasterSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.grademastersearch',
	//title : getCommonTranslation('QUICK_SEARCH'),
	//collapsible:true,
	//collapsed :false,
	//autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	layout : {
		type: 'anchor',
		layout: 'hbox'
	},
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
				xtype: 'customcombobox',
	            name: 'gradeTypeName',
	            fieldLabel: getExaminationTranslation('GRADE_TYPE'),	           
	            itemId:'gradeTypeItemId',
	            store:'gradeMaster.GradeTypeNameValueStore',
	            displayField:'value',
	            valueField:'value',
	            forceSelection:true,
	            typeAhead:true,
     			minChars:3
			},{	
				xtype: 'customcombobox',
	            name: 'grade',
	            fieldLabel: getExaminationTranslation('GRADE'),	         
	            itemId:'gradeItemId',
	            store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	            displayField:'gradeName',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,          
	            disabled:true,
    			queryMode:'local',
				minChars:3
		  },{	
				xtype: 'customcombobox',
	            name: 'gradeStatus',
	            itemId:'gradeStatus',
	            fieldLabel: getExaminationTranslation('GRADE_STATUS'),
	            store:'gradeMaster.GradeStatusStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
    			itemId:'gradeStatus',
				queryMode:'local',
				minChars:3
		   }]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{	
			xtype: 'customcombobox',
            name: 'groupNameValue',
            fieldLabel: getExaminationTranslation('GROUP_NAME'),
            store:'gradeMaster.GroupNameValueStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            typeAhead:true,
            disabled: true,
            hidden:true

	  }]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'gradeMasterSearchBtn',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getExaminationTranslation('RESET'),
            itemId: 'gradeMasterResetButtonId',
        	buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            handler: function() {
                var gradeSearchForm=this.up('form').getForm()
                gradeSearchForm.findField('grade').setDisabled(true);
                gradeSearchForm.reset();
            }
        }]
    }]
});


