Ext.define('Academia.view.hostel.hostelattendance.HostelAttendanceSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hostelattendancesearch',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getHostelTranslation('HOSTEL'),
            store : 'hostel.managehostel.hostel.HostelCodeName',
            editable : false,
            allowBlank : false,
            name: 'hostelCodeName',
            itemId: 'hostelCodeName',
            valueField: 'id',
            displayField: 'value',
            
        },{
            xtype: 'customcombobox',
            fieldLabel: getHostelTranslation('BUILDING'),
            store : 'hostel.managehostel.building.BuildingCodeName',
            editable : false,
            name: 'buildingCodeName',
            itemId: 'buildingCodeName',
            valueField: 'id',
            displayField: 'value'
        },{
            xtype: 'customcombobox',
            name: 'floorCodeNo',
            itemId: 'floorCodeNo',
            store:'hostel.managehostel.floor.FloorCodeName',
            fieldLabel: getHostelTranslation('FLOOR'),
            editable: false,
            displayField: 'value',
            valueField: 'id',
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			name: 'studentName',
			itemId: 'studentName',
			width: 460,
			fieldLabel: getHostelTranslation('OCCUPANT_NAME'),
			store: 'hostel.roomallocation.UserSmartSearchByUserType',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			 xtype: 'customcombobox',
			 name:'attendanceStatus',
			 itemId:'attendanceStatus',
			 store:'hostel.hostelattendance.HostelAttendanceStatus',
			 valueField : 'id',
			 displayField : 'value',
			 fieldLabel: getHostelTranslation('ATTENDANCE_STATUS'),
	         editable: false,
	  }]},{ 
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
					xtype: 'checkboxfield',
					width: 'auto',
					width: 226,
					style:{
						marginTop:'25px'
					},
					//labelAlign: 'right',
					itemId:'checkoutOccupant',
					boxLabel: getCommonTranslation('CHECKOUT_OCCUPANT'),
					name: 'checkoutOccupant',
					inputValue : true,
					uncheckedValue: false
				
				},
				
				{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'fromDate',
				itemId:'fromDate',
			//	endDateField : 'toDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					} 
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				//vtype : 'daterange'
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('TO_DATE'),
				name : 'toDate',
				itemId : 'toDate',
				//startDateField : 'fromDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				//vtype : 'daterange'
			}]
		},{
        	xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'searchButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
       }]
		
});
