/**
 * @author Deepak S
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.jobpostinggrid',
    store: 'hrRecruitmentProcess.jobPosting.JobPostingGridStore',
    title: getCommonTranslation('JOB_POSTING'),
    border: true,
    frame: false,
    //selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'jobpostingstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
    /*selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false,
        //injectCheckbox:1
    },*/
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrRecruitmentProcess.jobPosting.JobPostingGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getCommonTranslation('CONFIGURE_JOB_POSTING'),
			itemId:'configureJobLink'	
		},{
			text: getExaminationTranslation('APPLY_TO'),
			itemId: 'btnApplyToJobPosting',
		},{
			text:getFeeAndPaymentCommonTranslation('APPROVE'),
			itemId:'approveLink'	
		},{
			text:getCommonTranslation('PUBLISH_JOB'),
			itemId:'publishJobLink'	,
			hidden: true
		},{
			text:getCommonTranslation('UNPUBLISH_JOB'),
			itemId:'unpublishJobLink',
			hidden: true	
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
    columns: [{
        header: getCommonTranslation('JOB_CODE'),
        dataIndex: 'jobCode',
        flex: 1,
        sortable: true,
        /*renderer: function(value, meta, record) {
            return value.value;
        }*/
    },{
        header: getCommonTranslation('JOB_TITLE'),
        dataIndex: 'jobTitle',
        flex: 1,
        sortable: true
    }, {
        header: getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
        dataIndex: 'coordinator',
        flex: 1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(record.data != undefined){
        		return record.data.coordinator.value;
        	} else {
        		return '-';
        	}
        }
    },{
		header:  getCommonTranslation('FROM_DATE'),
		dataIndex: 'fromDate',
		flex:1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('TO_DATE'),
		dataIndex: 'toDate',
		flex:1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	}, {
        header: getPlacementTranslation('PLACEMENT_JOB_NO_OF_POSITIONS'),
        dataIndex: 'noOfPositions',
        flex: 1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)){
        		return '<a href=#>'+record.data.noOfPositions+'</a>';
        	} else {
        		return '-';
        	}
        }
    }, {
        header: getCommonTranslation('NO_OF_ACADEMY_LOCATIONS'),
        dataIndex: 'noOfAcademyLocations',
        flex: 1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)){
        		return '<a href=#>'+record.data.noOfAcademyLocations+'</a>';
        	} else {
        		return '-';
        	}
        }
    }, {
        header: getCommonTranslation('PUBLISH_STATUS'),
        dataIndex: 'publishStatus',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		if(value == "UNPUBLISHED"){
        			return "Unpublished";	
        		}else{
        			return "Published";
        		}
        		
        	}else{
        		return "Unpublished";
        	}            
        }
    }, {
        header: getCommonTranslation('JOB_MAPPING_STATUS'),
        dataIndex: 'mappingStatus',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		if(value == "UNMAPPED"){
        			return "Unmapped";	
        		}else{
        			return "Mapped";
        		}
        		
        	}else{
        		return "Unmapped";
        	}            
        }
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				
				if(value) {
		    		return 'Active';
		    	} else {
		    		return 'Inactive';
		    	}
			}
		}
    }]
});