/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.biometric.BMIAttendanceMachineUserMappingWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.bmiattendancemachineusermappingwin',
    title: getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),
    frame: true,
    modal: true,
    method: 'POST',
    maxHeight: 500,
    width:  320,
    height: 350,
    padding: '10 5 10 5',
    items: [{
		xtype: 'form',
		bodyPadding: '10 10 10 10',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
            xtype: 'hidden',
            itemId: 'attendanceMchineUserMappingId',
            name: 'attendanceMchineUserMappingId'
        },{
            xtype: 'hidden',
            itemId: 'userTypeId',
            name: 'userTypeId'
        }, {
	        xtype: 'fieldcontainer',
	        layout: 'vbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('BMI_MACHINE_ID_NAME'),
				name: 'attendanceMachineId',
				itemId:'attendanceMachineItemId',
				store: 'hrm.biometric.BMIAttendanceMachineUserMappingStore',
				displayField: 'valueCode',
				valueField: 'id',
				allowBlank: false,
				typeAhead:true,
				forceSelection :true,
				editable: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
			},
			{
				xtype:'textfield',
				name:'machineUserId',
				itemId:'machineUserItemId',
				fieldLabel: getCommonTranslation('BMI_MACHINE_USER_ID'),
				allowBlank: false,
				maxLength : 40
			},{
				xtype: 'customcombobox',
				name: 'userMappingActiveId',
				itemId:'userMappingActiveItemId',
				store:Ext.create('Academia.store.common.StatusComboStore'),
				labelAlign:'top',
				displayField: 'name',
				valueField: 'value',
				fieldLabel: getCommonTranslation('STATUS'),
				// value: 'Active',
				 editable: false
			}]
	    },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'bmiUserMappingSaveButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'bmiUserMappingCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        
	    }]	
	}]
});