/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.hrm.biometric.BMIEmployeeDownloadForm',{
	extend : 'Ext.form.Panel',
	alias : 'widget.bmiemployeedownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	width:'auto',
	height:'auto',
	items : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'machineName',
			itemId:'machineName',
			fieldLabel : getCommonTranslation('BMI_MACHINE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank: false,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hrm.biometric.BMIMachineNameStore');
					combo.bindStore(store)
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			name: 'lmAcademyLocationComboAS',
			itemId: 'lmAcademyLocationComboAS',
			editable: false,
			store: 'hrm.biometric.BMIMachineAcademyLocationStore',
			valueField: 'academyLocationIdtemp',
			displayField: 'academyLocationName',
			disabled:true,
			allowBlank: false
		}]
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('USER_GROUP_TYPE'),
            name: 'lmUserGroupType',
            itemId: 'lmUserGroupTypeAS',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            //allowBlank: false,
            editable: false,
           // disabled:true,
            queryMode: 'local',
            allowBlank: true
        },{
            xtype: 'customcombobox',
            itemId: 'lmDepartmentAS',
            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
            valueField: 'id',
            displayField: 'name',
            name: 'lmDepartment',
            editable: false,
            triggerAcation: 'all',
            fourceSelection: true,
           // disabled:true,
            store: 'department.ParentDepartmentByAccesibleStore',
            allowBlank: true
        },{
            xtype: 'customcombobox',
            itemId: 'lmDesignationComboAS',
            fieldLabel: getPersonModuleTranslation('DESIGNATION'),
            store: 'common.DesignationTypeStore',
            valueField: 'id',
            displayField: 'value',
            name: 'lmDesignationCombo',
            editable: false,
            triggerAcation: 'all',
           // disabled:true,
            fourceSelection: true,
            allowBlank: true
        }]
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		style: {
            marginTop: '15px'
        },
		items:[{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
				itemId: 'downoladBtnIdAS',
				disabled:true,
				//formBind: true,
				ui: 'CustomBtnSubmit'
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtnAS',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
