/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.hrm.biometric.BMIFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.bmifilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 462
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			name: 'academyLocationId',
			itemId:'academyLocationItemId',
			editable: true,
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			name:'machineId',
			itemId:'machineId',
			fieldLabel : getCommonTranslation('BMI_MACHINE_ID'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'code',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hrm.biometric.BMIMachineIDStore');
					combo.bindStore(store)
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'machineName',
			itemId:'machineName',
			fieldLabel : getCommonTranslation('BMI_MACHINE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hrm.biometric.BMIMachineNameStore');
					combo.bindStore(store)
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('ACTION'),
			name:'action',
			itemId : 'actionItemId',
			store: 'hrm.biometric.BMIActionStore',
			valueField: 'id',
			displayField: 'value',
			editable: false
		}]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype:'customcombobox',
			itemId:'cmbResourceGroupItemId',
			name:'resourceGroup',
			fieldLabel:getCommonTranslation('RESOURCE_GROUP'),
			store:'hrm.biometric.BMIResourceGroupStore',
			valueField : 'name',
			displayField : 'value',			
			editable:false,
			value:'',
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
			name:'resourceType',
			itemId : 'resourceTypeItemId',
			//store: 'hrm.biometric.BMIResourceTypeStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hrm.biometric.BMIResourceTypeStore');
					combo.bindStore(store)
				}
			}
			//queryMode : 'local'
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('RESOURCE_NAME'),
			name:'resourceName',
			itemId : 'resourceNameItemId',
			store: 'hrm.biometric.BMIResourceNameByTypeStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			disabled: true
		}]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBMIFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBMIFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});