/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.biometric.BMIResourceDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bmiresourcedetailsgrid',
    store: 'hrm.biometric.BMIResourceDetailsStore',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.biometric.BMIResourceDetailsStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    title : getCommonTranslation('BMI_LIST_OF_RESOURCES'),
    selType:'checkboxmodel',
    selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('RESOURCE_NAME'),
        dataIndex: 'resourceName',
        flex: 1
    },{
        header: getCommonTranslation('RESOURCE_TYPE'),
        dataIndex: 'resourceTypeName',
        flex: 1
    },{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1
    }]
});