/**
 * 
 */
Ext.define('Academia.view.hrm.employeePortal.HRMMyAttendanceFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmmyattendancefilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'startDate',
            itemId: 'startDateItemId',
            vtype: 'daterange',
            endDateField: 'endDateItemId',
            maxValue: new Date(),
            fieldLabel: getPersonModuleTranslation('START_DATE'),
            allowBlank: false,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId: 'endDateItemId',
            vtype: 'daterange',
            startDateField: 'startDateItemId',
            maxValue: new Date(),
            fieldLabel: getPersonModuleTranslation('END_DATE'),
            allowBlank: false,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('LATE_ARRIVAL_EARLY_GOING'),
            name: 'lateArrivalEarlyGoingId',
            itemId: 'lateArrivalEarlyGoingId',
           // store: 'department.DepartmentAcademyLocationWiseStore',
            store: Ext.create('Ext.data.Store', { fields: ['name'], data: [{ name: 'Late Arrival' }, { name: 'Early Going' }] }),
            valueField: 'name',
            displayField: 'name',
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnHRMMyAttendanceFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnHRMMyAttendanceFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});