/**
 * @author Ankur Jaiswal
 * 
 */
Ext.define('Academia.view.hrm.report.HRMAttendanceSummaryReportFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmattendancesummaryreportfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('DEPARTMENT'),
            name: 'department',
            itemId: 'departmentItemId',
            store: 'department.DepartmentAcademyLocationWiseStore',
            valueField: 'id',
            displayField: 'value',
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('GROUP'),
            name: 'userGroupId',
            itemId: 'userGroupItemId',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            editable: false,
            queryMode: 'local'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('FROM_DATE'),
            name: 'fromDate',
            itemId: 'fromDateItemId',
            endDateField: 'toDateItemId',
            format: CONSTANTS.DATE_FORMAT,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('To_Date'),
            name: 'toDate',
            itemId: 'toDateItemId',
            startDateField: 'fromDateItemId',
            format: CONSTANTS.DATE_FORMAT,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchHRMAttendanceSummaryReportFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetHRMAttendanceSummaryReportFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});