/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.report.HRMWorkingHourReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmworkinghourreportgrid',
    store: 'hrm.report.HRMWorkHourReportGridStore', // TODO change store
    title: getPersonModuleTranslation('HRM_EMPLOYEE_WORKING_HOUR'),
    border: true,
    refreshStoreData: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.report.HRMWorkHourReportGridStore', // TODO change store
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    plugins:[{
   	 ptype: 'rowexpander',
	     pluginId:'preAdmissionPaymentRowExpander',
	     rowBodyTpl:new Ext.XTemplate('<table style="border:1px solid black; width: 50%;">', 
	        		'<tr>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'Week Day' + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'In-Time' + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'Out-Time' + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'Total Time' + '</th>',
    		'</tr>',
    		'<tpl for="weekDaysDetail">',
    		'<tr>',
    			'<td style="width:100px;text-align:center">{[this.getWeekDayTranslation(values.weekday)]}</td>',
    			'<td style="width:100px;text-align:center">{[this.timeFormatChange(values.startTime)]}</td>', 
    			'<td style="width:100px;text-align:center">{[this.timeFormatChange(values.endTime)]}</td>', 
    			'<td style="width:100px;text-align:center">{[this.totalHoursVal(values.totalHours)]}</td>',
    		'</tr>',    		
    		'</tpl>',
    		'<tfoot>',
    		'<tr>',
    		'<td style="width:100px;text-align:center;font-weight: bold;">Total</td><td style="width:100px;"></td><td style="width:100px;"></td><td style="width:100px;text-align:center">{[this.summaryTotalVal(values.weekDaysDetail)]}</td>',
    		'</tr>',
    		'</tfoot>',
	        '</table>',{
	        timeFormatChange: function(inputValue) {
	            return timeRender(inputValue);
	        },
	        getWeekDayTranslation: function(weekday) {
	            return getCommonTranslation(weekday);
	        },
	        summaryTotalVal: function(weekDays) {
	        	
	        	var hour=0;
	            var minute=0;
	            var second=0;
	            
	            if(!isNullOrEmpty(weekDays)){	        		
	            	weekDays.forEach(function(days) {
	            		if(!isNullOrEmpty(days.totalHours))
	            		{
	            			var timeD = days.totalHours.split(':');
	            			hour = hour + parseInt(timeD[0]);
	            			minute = minute +  parseInt(timeD[1]);
	            			second = second + parseInt(timeD[2]);
	            		}
	            	});        

	            	if(minute >= 60){
	            		hour = hour + minute/60;
	            	}
	            	hour = parseInt(hour);
	            	minute = minute%60;
	            	minute = minute + second/60;
	            	second = second%60;
	            	minute = (minute < 10 ? '0' : '') + minute;
	            	return hour + ':' + minute;
	            }
	        },
	        totalHoursVal: function(val) {
	        	if(!isNullOrEmpty(val))
	        	{
	        		return val.slice(0, -3);
	        	}
	        }
	     })
   }],
    initComponent: function() {
        var grid = this;
        //grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: ['->', {
        xtype: 'button',
        itemId: 'exportReportItemId',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        text: getCommonTranslation('EXPORTREPORTS'),
    }],
    columns: [{
        header: getPersonModuleTranslation('HRM_EMP_ID'),
        dataIndex: 'empCode',
        flex: 1,
        sortable: false
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'empPrintName',
        flex: 1,
        sortable: false
    }, {
        header: getCommonTranslation('GENDER'),
        dataIndex: 'empGender',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('HRM_DEPT'),
        dataIndex: 'deptName',
        flex: 1,
        sortable: false
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'empDesignation',
        flex: 1
    }, {
        header: getCommonTranslation('GROUP_TYPE'),
        dataIndex: 'empGroupType',
        flex: 1,
        /*renderer:function(value) {
        	if(value.toUpperCase()=="FACULTY"){
        		return getCommonTranslation(value.toUpperCase());
        	}else if(value.toUpperCase()=="OTHER_EMPLOYEE"){
        		return getCommonTranslation(value.toUpperCase());
        	}else{
        		return value;
        	}
        }*/
    }, {
        header: getCommonTranslation('EMPLOYEE_TYPE') + ' / '+ getCommonTranslation('FACULTY_TYPE'),
        dataIndex: 'empEmpType',
        flex: 1
    }, {
        header: getCommonTranslation('CALENDAR'),
        dataIndex: 'calendarName',
        flex: 1
    }, {
        header: getPersonModuleTranslation('START_DATE'),
        dataIndex: 'staffCalendarStartDate',
        flex: 1,
        renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('TILL_DATE'),
        dataIndex: 'staffCalendarEndDate',
        flex: 1,
        renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('HRM_WORKING_DAYS'),
        dataIndex: 'empWorkingDays',
        flex: 1,
        sortable: true
    },{
		header:  getPersonModuleTranslation("VIEW"),
		dataIndex: 'view',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			return '<a href=#>View</a>';
		}
	}]
});