/**
 * @author Santosh Sahu
 */
Ext.define('Academia.view.kohalibrarytransaction.LibraryBranchAndCategoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.librarybranchandcategorygrid',
	store: 'kohalibrarytransation.LibraryBranchAndCategoryStore',
	title: getCommonTranslation('LIBRARY_CONFIGURATION'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'kohalibrarytransation.LibraryBranchAndCategoryStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	}, tbar: [{
		 xtype: 'button',
		 itemId: 'mapLibraryBtn',
		 text: getCommonTranslation('MAP_LIBRARY')
	 },{
		 xtype: 'button',
		 itemId: 'patronCategoryMapBtn',
		 text: getCommonTranslation('MAP_PATRON_CATEGORY'),
	 }],
	columns: [{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'locationName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('LIBRARY_ASSOCIATED'),
		dataIndex: 'branchCount',
		flex:.1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header:  getCommonTranslation('PATRON_CATEGORY_ASSOCIATED'),
		dataIndex: 'categoryCount',
		flex:.1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});

