/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.LeaveSettingsGrid', {
	 //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leavesettingsgrid',
    store: 'leavemanagement.EligibilitySettingGridStore',
    border: true,
    autoScroll: false,
    frame:false,
//    selType:'checkboxmodel',
    title:getCommonTranslation('ELIGIBILITY_SETTINGS_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
//		 showHeaderCheckbox: true,
	     checkOnly : true, 
	     allowDeselect: false,
	
   },
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'eligilibitysettingfilter':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'leavemanagement.EligibilitySettingGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    
	   },{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnApplyToItemId',
			tooltip: getExaminationTranslation('APPLY_TO'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('APPLY_TO'),
			style:{
//					marginLeft:'5px',
					marginRight:'10px'
			}
		}]
	}],
    columns: [{
    	header: getExaminationTranslation('S_NO'),
    	xtype: 'rownumberer',
        sortable: false,
        align:'center',
        flex:.2,
        locked: false,
        hidden:true
    },{
        header:getCommonTranslation('ELIGIBILITY_CODE'),
        dataIndex: 'eligibilityCode',
        flex:.4,
        sortable:true
    }, {
        header: getCommonTranslation('AVAILABILITY_PERIOD'),
        dataIndex: 'availabilityPeriodType',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return "-";
			}   	                     
        }
    }, {
        header: getCommonTranslation('TOTAL_DAYS'),
        dataIndex: 'availableLeaveDays',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('CREDIT_PERIOD'),
        dataIndex: 'creditPeriodType',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return "-";
			}                   
        }
    },{
        header: getCommonTranslation('DAYS_TO_CREDIT'),
        dataIndex: 'leaveDaysToCredit',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return record.data.leaveDaysToCredit;          
			} else {
				return "-";   
			} 
		}
    }, {
        header: getCommonTranslation('START_FORM'),
        dataIndex: 'camelCaseValue',
        flex:.3,
        sortable: true
    }]
});