/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMApprovalSetupGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmapprovalsetupgrid',
    store: 'leavemanagement.leaveapprovalsetup.LMConfigurationGridStore',
    title: getPersonModuleTranslation('LMAS_CONFIGURATION_DETAIL'),
    border: true,
    frame: false,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false,
        //injectCheckbox:1
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'lmapprovalsetuptabstructure':1
		}
	},
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.leaveapprovalsetup.LMConfigurationGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        
            xtype: 'button',
            text: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
            itemId: 'viewConfigureBtnId',
           scale: CONSTANTS.BUTTONSIZE,
            tooltip: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE')
    },{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('EMPLOYEE_ID'),
        dataIndex: 'employeeCode',
        flex: 1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(record.data != undefined){
        		return '<a href=#>'+record.data.employeeCode+'</a>';
        	} else {
        		return '-';
        	}
        }
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'employeeName',
        flex: 1,
        sortable: true,
        /*renderer: function(value, meta, record) {
            return value.value;
        }*/
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocName',
        flex: 1,
        sortable: true,
    }, {
        header: getPersonModuleTranslation('DEPARTMENT'),
        dataIndex: 'department',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		return value;
        	}else{
        		return "-";	
        	}            
        }
    }, {
        header: getPersonModuleTranslation('LMAS_GROUP_NAME'),
        dataIndex: 'groupName',
        flex: 1,
        sortable: true,
    }, {
        header: getCommonTranslation('USER_TYPE'),
        dataIndex: 'usertype',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		return value;
        	}else{
        		return "-";	
        	}            
        }
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designation',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		return value;
        	}else{
        		return "-";	
        	}            
        }
    }, {
        header: getPersonModuleTranslation('LMAS_JOINING_DATE'),
        dataIndex: 'joiningDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
        	if(!isNullOrEmpty(date)){ 
        		return dateRender(date);
        	}else{
        		return "-";	
        	} 
        }        
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'configurationstatus',
        flex: 1,
        sortable: true,
        /*renderer: function(date) {
            return dateRender(date);
        }*/
    }, {
        header: getPersonModuleTranslation('LMAS_APPROVAL_FLOW_TYPE'),
        dataIndex: 'approvalType',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(value == 'AUTO_APPROVE'){
        		return 'Auto Approve';
        	}else if(value == 'PARALLEL'){
        		return 'Parallel';
        	}else if(value == 'SEQUENTIAL'){
        		return 'Sequential';
        	}else{
        		return value;
        	}
        }
    }]
});