/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMPastLeaveRequestGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmpastleaverequestgrid',
    store: 'leavemanagement.leaveapprovalsetup.LMPastLeaveRequestStore',
    title: getPersonModuleTranslation('LMAS_PAST_LEAVE_DETAIL'),
    border: true,
    autoScroll: false,
    frame: false,
    // selType:'checkboxmodel',
    headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'lmleaverequesttabstructure': 1
    	}
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    /*selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false,
        //injectCheckbox:1
    },*/
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            itemId: 'lmDockedItemId',
            plugins: ['pagesize'],
            store: 'leavemanagement.leaveapprovalsetup.LMPastLeaveRequestStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        cls: 'windowBtnPos',
        defaults: {
            labelAlign: 'top',
        },
        /* items: [{
             xtype: 'button',
             text: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
             itemId: 'viewConfigureBtnId',
             ui: 'CustomBtnSubmit',
             scale: CONSTANTS.BUTTONSIZE,
             tooltip: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
         }]*/
    }],
    columns: [{
        header: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
        dataIndex: 'hrLeaveTypeIDCode',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }, {
        header: getPersonModuleTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return dateRender(value);
            } else {
                return "-";
            }
        }
    }, {
        header: getPersonModuleTranslation('To_Date'),
        dataIndex: 'toDate',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return dateRender(value);
            } else {
                return "-";
            }
        }
    }, {
        header: getPersonModuleTranslation('REQUEST_DATE'),
        dataIndex: 'requestDate',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return dateRender(value);
            } else {
                return "-";
            }
        }
    }, {
        header: getPersonModuleTranslation('HRM_TOTAL_DAYS'),
        dataIndex: 'totalDays',
        flex: 1,
        sortable: true,
    }, {
        header: getPersonModuleTranslation('LMAS_REASON'),
        dataIndex: 'reason',
        flex: 1,
        sortable: true,
    }, {
        header: getPersonModuleTranslation('LMAS_WORK_HANDED_OVER_TO'),
        dataIndex: 'alternateEmpNames',
        flex: 1,
        sortable: true,
    },{
        header: getPersonModuleTranslation('DOCUMENT'),
        dataIndex: 'document',
        itemId: 'documentItem',
        sortable: true,
        flex: 1,
        renderer: function(value, metadata, record) {
            var msg = "";
            if (!isNullOrEmpty(value) && !isNullOrEmpty(value.id)) {
                    msg = '<a href="#">' + "doc" + '</a>';
                }
            return msg;
        }
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
    }, {
        header: getPersonModuleTranslation('LMAS_ACTION'),
        dataIndex: 'withDraw',
        flex: 1,
        sortable: true,
        renderer: function(value, metadata, record) {
        	if(!isNullOrEmpty(record) && record.get('status') == "Approved"){
        		var fromDate =  new Date(record.get('fromDate'));
        		var toDate =  new Date(record.get('toDate'));
        		var currentDate = new Date().setHours(0,0,0,0);
        		currentDate = new Date(currentDate);
        		if(fromDate>=currentDate && currentDate<=toDate){
        			return '<a href="#">'+'Cancel'+'</a>';
        		}
        		else if(toDate>=currentDate){
        			return '<a href="#">'+'Cancel'+'</a>';
        		}
        	}
        	else if (!isNullOrEmpty(value)) {
            	if(value=='Withdrawn'){
            		return '<a href="#">'+'Withdraw'+'</a>';
            	}else{
            		return '<a href="#">'+value+'</a>';
            	}
            } else {
                return '';
            }
        }
    },{
    	header: getPersonModuleTranslation('TIMELINE'),
    	dataIndex: 'id',
    	flex: 1,
    	renderer: function(value, metadata, record) {
    		var msg = "";
    		if (!isNullOrEmpty(value) && !isNullOrEmpty(value)) {
    			msg = '<a href="#">' + "View" + '</a>';
    		}
    		return msg;
    	}
    }]
});