/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.leavemanagement.leavegeneralsetting.LeaveCominationFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.leavecominationformwindow',
    modal: true,
    resizable: false,
    title: getPersonModuleTranslation('LEAVE_COMBINATION_GENERAL_SETTING'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'leaveCominationFormItemId',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'hidLeaveCombinationId',
            name: 'id'
        },   {
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                name: 'leaveType',
                itemId: 'leaveTypeCombinationItemId',
                valueField: 'id',
                displayField:'value',
                allowBlank: false,
                forceSelection: true,
                fieldLabel: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
                editable: false,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.leavemanagement.leavegeneralsetting.LeaveTypeGeneralSettingStore');
                        combo.bindStore(store);
                    }
                }
            }, {
    			xtype: 'multiselectcombofield',
    			name: 'leaveCombineWith',
    			width:460,
    			allowBlank: false,
    			maxHeight:400,
    			itemId: 'leaveCombineWithItemId',
    			autoScroll:true,
    			disabled: true,
    			store:Ext.create('Academia.store.leavemanagement.leavegeneralsetting.LeaveTypeGeneralSettingStore'),
    			cls:'multiBrandCampusCls',
    			displayField: 'value',
    			valueField: 'id',
    			fieldLabel: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_COMBINE_WITH'),
    			listConfig: {		   
    				maxHeight:260,
    				listeners: {
    					beforeshow: function(picker) {
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'btnSaveLeaveCombinationForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelLeaveCombinationForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
