/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.leavegeneralsetting.LeaveSanctioningDaysGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leavesanctioningdaysgrid',
    store: 'leavemanagement.leavegeneralsetting.LeaveSanctioningDaysStore',
    title: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_ENTRY_TABLE'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		hidden: true,
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_SERIAL_NO'),
        dataIndex: 'serialNo',
        flex: 0.4,
        sortable: true
    }, {
        header: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
        dataIndex: 'leaveType',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'leaveType',
            itemId: 'leaveTypeSanctioningItemId',
            valueField: 'id',
            displayField:'value',
            forceSelection: true,
            store:Ext.create('Academia.store.leavemanagement.leavegeneralsetting.LeaveTypeGeneralSettingStore'),
            editable: false,
            listeners: {
                blur: function(combo, r) {
                	combo.getStore().on('beforeload', function(){
						this.getProxy().extraParams = {
							leaveTypeNotInIDs: null
						};
					});
                	combo.getStore().load();
                },
                focus: function(combo, e, eOpts) {
					//combo.lastQuery = null;
                	var me = this.up('leavesanctioningdaysgrid');
					combo.getStore().on('beforeload', function(){
						this.getProxy().extraParams = {
							leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIdsSanctioning(combo)
						};
					});
					combo.getStore().load();
				}
            }
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(record.get('leaveTypeName')){
						return record.get('leaveTypeName')
					}else if(index !== -1){
						record.data.leaveTypeName = rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}
				}
				catch(e){
					return null;
				}
			} else {
				if(!isNullOrEmpty(value) && value !== '') {
					var editor = rec.column.getEditor();
					var recTypeName = record.get('leaveTypeName');
					editor.store.load();
					if(!isNullOrEmpty(recTypeName)){
						return recTypeName;
					}
				}
				else{
					if(Ext.isDefined(record.get('leaveType')) && isNullOrEmpty(record.get('leaveType'))){
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
			}
        }
    }, {
        header: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_MIN_DAYS'),
        dataIndex: 'minDays',
        flex: 0.5,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'minDays',
            width:50,
            minValue:0,
            maxLength: 6,
			enforceMaxLength : true,
			keyNavEnabled: false,
            mouseWheelEnabled: false,
            allowExponential: false,
            decimalPrecision : 2,
            itemId: 'minDaysItemId'
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
				if(Ext.isDefined(record.get('minDays')) && isNullOrEmpty(record.get('minDays'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
        	}
        }
    }, {
        header: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_MAX_DAYS'),
        dataIndex: 'maxDays',
        flex: 0.5,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'maxDays',
            width:50,
            minValue:1,
            maxLength: 6,
			enforceMaxLength : true,
			keyNavEnabled: false,
            mouseWheelEnabled: false,
            allowExponential: false,
            decimalPrecision : 2,
            itemId: 'maxDaysItemId',
            validator: function(val) {
            	var minDaysVal = this.ownerCt.up().getSelectionModel().getSelection()[0].get('minDays');
                if (!Ext.isEmpty(val)  && minDaysVal<=val) {
                    return true;
                }
                else {
                    return "The minimum value for this field is " + minDaysVal;
                }
            }
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
				if(Ext.isDefined(record.get('maxDays')) && isNullOrEmpty(record.get('maxDays'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
        	}
        }
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        tooltip : getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        sortable: true,
        renderer: function(value, meta, record) {
        	if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)){
        		if(record.store.data.length-1 == meta.recordIndex){
        	return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight:20px !important'></div>";
        		}

        	}else{
        		return '';
        	}
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls'></div>";
            }
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
            	var columnDataIndex = obj.context.field;
                if (!isNullOrEmpty(editor.record.data.id)) {
                	if (columnDataIndex == "leaveType") {
                        return false;
                    }
                }
            }
        }
    }],
    getAllSelectedLeaveTypeIdsSanctioning: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('leaveType') && !isNullOrEmpty(rec.get('leaveType'))){
    			ids.push(rec.get('leaveType'));
    		}
    	});
    	return ids.join();
    }
});
