/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.report.LMLeaveSLAReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmleaveslareportgrid',
    store: 'leavemanagement.report.LMLeaveSLAReportGridStore',
    title: getServiceRequestTranslation('LEAVE_SLA_REPORT'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.report.LMLeaveSLAReportGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION_NAME'),
        dataIndex: 'academyLocation',
        flex: 1,
        sortable: true,
    },{
        header: getPersonModuleTranslation('LM_TOTAL_REQUESTS'),
        dataIndex: 'totalRequest',
        flex: 1,
        renderer: function(value, metadata, record) {
    		var msg = '<a href="#">' + value + '</a>';
    		return msg;
    	}
    },{
        header: getPersonModuleTranslation('LM_SLA_COMPLIED'),
        dataIndex: 'complied',
        flex: 1,
        renderer: function(value, metadata, record) {
        	if(value != 0) {
    			var msg = '<a href="#">' + value + '</a>';
    			return msg;
    		}
    		return '';
    	}
    },{
        header: getPersonModuleTranslation('LM_SLA_VIOLATED'),
        dataIndex: 'violated',
        flex: 1,
        renderer: function(value, metadata, record) {
    		if(value != 0) {
    			var msg = '<a href="#">' + value + '</a>';
    			return msg;
    		}
    		return '';
    	}
    }, {
    	header: getPersonModuleTranslation('LM_SLA_COMPLIANCE_PERCENTAGE'),
    	dataIndex: 'compliancePercentage',
    	flex: 1,
    	 renderer: function(compliancePercentage, metadata, record) {
    		 if(Number.isInteger(compliancePercentage)) {
     		return (compliancePercentage + '%');	
     	}else {
     		var compliancePercentage =  Ext.util.Format.number(compliancePercentage, '0.00');
         	return (compliancePercentage + '%');
     	}}
    }],
});