/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.sanctionleave.SanctionApplyToGrid', {
	 //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.sanctionapplytogrid',
    store: 'leavemanagement.sanctionleave.SanctionLeaveTypeGridStore',
    border: true,
    autoScroll: false,
    frame:false,
//    selType:'checkboxmodel',
    title:getCommonTranslation('SETTING_APPLY_TO_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
//		 showHeaderCheckbox: true,
	     checkOnly : true, 
	     allowDeselect: false,
	
   },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'leavemanagement.sanctionleave.SanctionLeaveTypeGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
 tbar: [{
	 xtype: 'button',
	 itemId: 'btnAdd',
	 tooltip: getCommonTranslation('ADD'),
	 glyph: ICONGLYPH.ADDGLYPH
 },{
	 xtype: 'button',
	 itemId: 'btnEdit',
	 tooltip: getCommonTranslation('EDIT'),
	 glyph: ICONGLYPH.EDITGLYPH
 },{
     xtype: 'button',
     itemId: 'btnDelete',
     cls: 'CustomToolbarBtnReject',
     tooltip: getCommonTranslation('DELETE'),
     glyph: ICONGLYPH.DELETEGLYPH
 }],
    columns: [{
    	header: getExaminationTranslation('S_NO'),
    	xtype: 'rownumberer',
        sortable: false,
        align:'center',
        flex:.2,
        locked: false,
        hidden:true
    },{
        header:getCommonTranslation('LEAVE_NAME'),
        dataIndex: 'leaveName',
        flex:.4,
        sortable:true
    }, {
        header: getCommonTranslation('ELIGIBILITY_BASED_ON'),
        dataIndex: 'eligibilityCtiteria',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return "-";
			}   	                     
        }
    }, {
        header: getCommonTranslation('EMPLOYEE_ATTRIBUTE_TYPE'),
        dataIndex: 'employeeAttributeType',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return "-";
			}                   
        }
    }, {
        header: getCommonTranslation('ATTRIBUTE_VALUE'),
        dataIndex: 'employeeAttributeValues',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(record.data.employeeAttributeValues!=null){
        		if(record.data.employeeAttributeValues.length==0){
        			return value; 
        		} else {
        			return '<a href=#>'+record.data.employeeAttributeValues.length+'</a>';
        		}
			} else {
				return '-';
			}              
        }
    },{
        header: getCommonTranslation('ACADEMY_LOCATIONS'),
        dataIndex: 'academyLocationIdName',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.academyLocationIdName)) {
				if(record.data.academyLocationIdName.length==0){
					return value;  
				} else {
					return '<a href=#>'+record.data.academyLocationIdName.length+'</a>';
				}
			} else {
				return "-";   
			} 
		}
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'validFrom',
        flex:.3,
        sortable: true,
		renderer:function(date) {
			return dateRender(date);
		}
    }]
});