/***
 * this window for change language
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.login.ChangeLanguageWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.changelanguagewindow',
    modal: true,
    style:{
    	height:'auto'
    },
    resizable: false,
    title: getCommonTranslation('CHANGE_LANGUAGE'),
    items: [{
        xtype: 'form',
        itemId: 'changelanguageForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
        	width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            itemId: 'changeLanguage',
            name:'changeLanguage',
            store: 'common.ChangeLanguageStore',	    
            valueField:'code',
            displayField:'itemValue',
            editable:false,
            listeners:{
            	render : function(obj){
            		var languageName = localStorage.getItem('userLanguage');
            		if(languageName==null){
            			obj.setValue('default');
            		}else{
            			obj.setValue(languageName);
            		}
            	}
            }
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSavePassword',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                listeners : {
                	click : function(obj){
                		var form = obj.up('form');
                		var value  = form.down("#changeLanguage").getValue();
                		if(value!=localStorage.getItem('userLanguage')){
                    		localStorage.setItem('userLanguage', (value));
                    		window.location.reload();
                		}
                		obj.up('changelanguagewindow').close();
                	}
                }
            }, {
                xtype: 'button',
                itemId: 'cancelSavePassword',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners:{
                	click : function(obj){
                		obj.up('changelanguagewindow').close();
                	}
                }
            }]
        }]
    }]

});