/**
 * Social  Form
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.login.SocialMappingForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.socialmappingform',
	plugins : "formlabelrequired",
//	bodyStyle: { background:'#f0f0f0'},
	/**
	 * bodyStyle without bg-image
	 */
	//bodyStyle: { background:'#f0f0f0'},
	
	/**
	 * bodyStyle With image for collage instance 
	 */
	//bodyStyle: { backgroundImage:'url(resources/images/backgroundimage.jpg)', backgroundRepeat: 'no-repeat',  backgroundPosition: 'center'},
	
	/**
	 * bodyStyle With image for school instance 
	 */
	bodyStyle: { backgroundImage:'url(resources/images/backgroundimageforschool.jpg)', backgroundRepeat: 'no-repeat',  backgroundPosition: 'center'},
	
	margin:0,
	layout : {
		align : 'center',
		pack : 'start', 
		type : 'vbox'
	},
	items : [ {
		xtype : 'fieldset',
		cls:'loginBox',
		style: { background:'#ffffff', border:'1px solid #D1D1D1', padding:'35px !important', display: 'table',marginTop:'50px !important'},
		height: 'auto',
		width: 330,
		defaults:{
			labelAlign: 'top',
			width: 260
		},
		items : [{
			xtype: 'component',
			html: getCommonTranslation('LOGINHEADERLABEL'),
			translationKey:'LOGIN',
			cls: 'CenterLoginText',
			style: {
				fontSize: '21px',
				fontFace: 'bold',
				textAlign: 'center',
				marginBottom:'15px !important',
				color:'#000000'
			}
		},{
			xtype: 'dataview',
            itemId: 'passwordPolicyTemplate',
            tpl:  new Ext.XTemplate('<tpl></tpl>')
		}, {
			xtype : 'textfield',
			allowBlank: false,
			name: 'username',
			id: 'username',
			translationKey:'USERNAME',
			translationObject: 'COMMON',
			fieldLabel : getCommonTranslation('USERNAME'),
			value:'',
			width: 255,
			style:{marginBottom:'15px !important'},
			listeners: {
				afterrender: function(field) {
					field.focus();
				}
			}
		}, {
			xtype : 'textfield',
			allowBlank: false,
			inputType : 'password',
			name: 'password',
			itemId: 'password',
			id: 'password',
			width: 255,
			translationKey:'PASSWORD',
			fieldLabel : getCommonTranslation('PASSWORD'),
			value:''
		},{
			xtype: 'text',
			itemId : 'forgotPasswordLink1',
			text : getCommonTranslation('FORGOTPASSWORDTEXT'),
			translationKey:'FORGOTPASSWORDTEXT',
			cls : 'forgotpasswordlink',
			style:{marginBottom:'15px !important', fontSize:'10px', textAlign: 'right !important'},
			renderer: function (val, metadata, record) {
				metadata.style = 'cursor: pointer;'; 
				return val;
			}
		},{
			xtype: 'button',
			formBind: true,
			text : getCommonTranslation('LOGIN'),
			translationKey:'LOGIN',
			itemId: 'socialLoginBtn',
			ui: 'CustomBtnSubmit',
			style:{width:'100% !important'},
			scale: 'medium'
		}]
	}]
});
