/**
 *  @author Niklesh T
 * 
 */
Ext.define('Academia.view.manageCeremony.AddNewCeremonyForm' ,{
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.addNewCeremonyForm',
	//formCode:'electionform',
    itemId: 'electionform',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:true,
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	cls: 'adddNewCeremonyFormBox',
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
			xtype: 'hidden',
			itemId:'ceremonyPrimaryItemId',
			name: 'ceremonyPrimaryId'
        },{
				xtype: 'textfield',
				fieldLabel:getCommonTranslation('CEREMONY_ID'),
				name: 'ceremonyID',
				itemId:'ceremonyItemId',
				typeAhead:true,
				maxLength: 99
					
	        },{
				xtype: 'textfield',
				fieldLabel:getCommonTranslation('CEREMONY_NAME'),
				name:'ceremonyName',
				itemId:'ceremonyNameItemId',
				typeAhead: true,
				maxLength: 255,
				forceSelection: true,
				allowBlank: false
			},{
				xtype : 'textfield',
				fieldLabel : getCommonTranslation('CEREMONY_NAME_OTHER_LANGUAGE'),		
				name : 'ceremonyNameOtherlan',
				itemId : 'ceremonyNameOtherlanItemId',
				maxLength: 255,
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items: [{
				xtype: 'datefield',
				fieldLabel:getCommonTranslation('DATE'),
				name: 'ceremonyDate',
				itemId:'ceremonyDateItemId',
				allowBlank:false,
				minValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'timefield',
				fieldLabel:getCommonTranslation('TIME_FROM'),
				name: 'ceremonyTimeFrom',
				itemId:'ceremonyTimeFromItemId',
				width:115,
				allowBlank:false,
				disabled:true
			},{
				xtype : 'timefield',
				fieldLabel:getCommonTranslation('TIME_TO'),
				name:'ceremonyTimeTo',    			
				itemId:'ceremonyTimeToItemId',
				width:115,
				allowBlank:false,
				disabled:true
			},{
    			xtype: 'textfield',
    			fieldLabel:getCommonTranslation('CEREMONY_CREATED_BY'),
    			name: 'ceremonyCreatedBy',
    			itemId:'ceremonyCreatedByItemId', 
    			typeAhead:true,
    			allowBlank:false,
    			readOnly: true
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items: [{
				xtype: 'customcombobox',
				name: 'accountingYear',
				itemId: 'accountingYear',
				fieldLabel: getCommonTranslation('YEAR'),
				store:'scholarships.ScholarshipAccountingYearStore',
				valueField: 'id',
				displayField: 'currentAccountingYear',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'datefield',
				fieldLabel:getCommonTranslation('LAST_DATE_ABSENTIA'),
				name: 'lastDateAbsentia',
				itemId:'lastDateAbsentia',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			},{
				xtype: 'numberfield',
				name: 'capacity',
				fieldLabel:getCommonTranslation('CAPACITY'),
				itemId: 'capacity',
				minValue:0,
				maxValue: 99999,
				enableKeyEvents: true,
				listeners:{
					keypress: function (field, e) {
		                // Prevent input if not a number (keyCode 48-57 for numbers 0-9)
		                // or not backspace (keyCode 8), delete (keyCode 46)
		                if (e.getKey() < 48 || e.getKey() > 57) {
		                    e.preventDefault();
		                }
		            }
				}
			},
			]
    	},{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items: [{
                xtype: 'statusCombo',
                name: 'statusComboItemId',
                itemId:'statusComboItemId',
                displayField: 'name',
                valueField: 'value',
                allowBlank:false,
                value:true
            },
    		{
				xtype: 'datefield',
				fieldLabel:getCommonTranslation('EFFECTIVE_PASSOUT_DATE'),
				name: 'effectivePassoutDate',
				itemId:'effectivePassoutDate',
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			},
			{
				xtype: 'datefield',
				fieldLabel:getCommonTranslation('APPROVAL_DATE'),
				name: 'approvalDate',
				itemId:'approvalDate',
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			}
    		
    		]
    	},
    	{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items: [
    		{
    			xtype : 'textarea',			
    			fieldLabel: getCommonTranslation('VENUE'),
				name: 'ceremonyVenue',
				itemId:'ceremonyVenueItemId',
				maxLength:1000
    		},{
    			xtype : 'textarea',			
    			fieldLabel: getCommonTranslation('DESCRIPTION'),
				name: 'ceremonyDes',
				itemId:'ceremonyDesItemId',
				maxLength:1000
    		}]
    	},{

    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SAVE") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'resetBtnToCere',
    			name: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]
});

