Ext.define('Academia.view.manageCeremony.CeremoneyAddMappingProgramGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.ceremoneyaddmappingprogramgrid',
	title : getCommonTranslation('PROGRAM_GROUP'),
	store: 'manageCeremony.CeremoneyProgramGroupMappingStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programsearchcombo',
		itemId:'programsearchcombo',
		store: 'manageCeremony.CeremoneyProgramGroupSmartComboStore',
		valueField: 'longValue',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'qry',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		dataIndex : 'secondValue',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_GROUP_NAME'),
		dataIndex : 'value',
		flex : 1	 
	}]
});