/**
 * @author Ramkrishna Yadav
 */
Ext.define('Academia.view.mangeElections.mangeElections.ElectionsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.electionsgrid',
	store: 'election.election.ElectionGridStore',
	title: getCommonTranslation("LIST_OF_ELECTIONS"),
	border: true,
	frame:false,
	refreshStoreData:true,
	
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'electionstabstructure':1
		}
	},
	
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'election.election.ElectionGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getCommonTranslation('CANDIDATE_LIST'),
			itemId: 'condidateLink',
		},{
			text:getCommonTranslation('VOTER_POOL'),
			itemId:'voterPoolLink'
		},{
			text:getCommonTranslation('ELECTION_RESULTS'),
			itemId:'electionResultLink',
			hidden:true
		},{
			text:getCommonTranslation('COPY_ELECTION'),
			itemId:'copyElectionLink'
		},{
			text:getCommonTranslation('PRINT_ELECTION_SHEET'),
			itemId:'printElectionSheetLink'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header:  getCommonTranslation("ELECTION_CODE"),
		dataIndex:'electionCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("ELECTION_NAME"),
		dataIndex: 'electionName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("ELECTION_TYPE"),
		dataIndex: 'electionTypeCSM',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return record.data.electionTypeCSM.value
		}
	},{
		header:  getCommonTranslation("ACADEMIC_TERM"),
		dataIndex: 'academicTerm',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return record.data.academicTerm.value
		}
		
	},{
		header:  getCommonTranslation('VOTING_START_DATE_TIME'),
		dataIndex: 'votingStartDate',
		flex:.1,
		renderer: function(value, metadata, record) {
			var votingtime=  dateRender(value)+ " " + timeRender(record.data.votingStartTime);
			return votingtime;
		}
	},{
		header:  getCommonTranslation('VOTING_END_DATE_TIME'),
		dataIndex: 'votingEndDate',
		flex:.1,
		renderer: function(value, metadata, record) {
			var votingendTime=  dateRender(value)+ " " + timeRender(record.data.votingEndTime);
			return votingendTime;
		}
	},{

		header:  getCommonTranslation('STATUS'),
		dataIndex: 'isActive',
		flex:.1,
		renderer : function(value, metadata, record) {
			var val = '';
			if(record.data.isDeleted==true){
				val = 'Deleted';
			}else if(value == true) {
				val = 'Active';
			}else {
				val = 'Inactive';
			}
			return val;
		}
	},{
		header:  getCommonTranslation("ELECTION_NAME_OTHER"),
		dataIndex: 'electionNameInOtherLanguage',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation("ADMIN_CAPTURE_VOTES"),
		dataIndex: 'isAdminCaptureVote',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			if(value==true)
				return 'Yes';
			else 
				return 'No';
		}
	},{
		header:  getCommonTranslation("VOTING_POOL"),
		dataIndex: 'voterPoolSize',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			if(isNullOrEmpty(value)){
				return '';
			}else if(value==1){
				return getCommonTranslation(record.data.electionVotingPools[0].votingPool);
			}else{
				return '<a href="#">' + value + '</a>';
			}
			
		}
	},{
		header:  getCommonTranslation("ADMIN_CAPTURE_START_DATE_AND_TIME"),
		dataIndex: 'adminCaptureStartDate',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			var votingendTime=  dateRender(value)+ " " + timeRender(record.data.adminCaptureStartTime);
			return votingendTime;
		}
	},{
		header:  getCommonTranslation("ADMIN_CAPTURE_END_DATE_AND_TIME"),
		dataIndex: 'adminCaptureEndDate',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			var votingendTime=  dateRender(value)+ " " + timeRender(record.data.adminCaptureEndTime);
			return votingendTime;
		}
	},{
		header:  getCommonTranslation("REFERENDUM_ONE"),
		dataIndex: 'isReferendumOne',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			if(value==true)
				return 'Yes';
			else 
				return 'No';
		}
	},{
		header:  getCommonTranslation("REFERENDUM1_QUESTION_ENGLISH"),
		dataIndex: 'referendumOneQuestionInEnglish',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation("REFERENDUM1_QUESTION_OTHER"),
		dataIndex: 'referendumOneQuestionInOtherLang',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation("REFERENDUM_TWO"),
		dataIndex: 'isReferendumTwo',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			if(value==true)
				return 'Yes';
			else 
				return 'No';
		}
	},{
		header:  getCommonTranslation("REFERENDUM2_QUESTION_ENGLISH"),
		dataIndex: 'referendumTwoQuestionInEnglish',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation("REFERENDUM2_QUESTION_OTHER"),
		dataIndex: 'referendumTwoQuestionInOtherLang',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation("ELECTION_DESCRIPTION"),
		dataIndex: 'electionDescriptionInEnglish',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			return '<a href="#">' + "View" + '</a>';
		}
	},{
		header:  getCommonTranslation("ELECTION_DESCRIPTION_OTHER"),
		dataIndex: 'electionDescriptionInOtherLang',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			return '<a href="#">' + "View" + '</a>';
		}
	},{
		header:  getCommonTranslation("LAST_UPDATED_DATE_AND_TIME"),
		dataIndex: 'lastUpdate',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			return dateRender(record.data.lastUpdate)+ " " + timeRender(record.data.lastUpdate) ;
		}
	},{
		header:  getCommonTranslation("LAST_UPDATED_BY"),
		dataIndex: 'lastUpdatedBy',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			return record.data.lastUpdatedBy.value;
		}
	}]
});
