/**
 * @author prathamesh.sheth
 *  
 * This component is used for to add Dynamic Document for Adhoc Messaging.
 *   
 */	   
Ext.define('Academia.view.messaging.AdhocMesagingReportFormWindow',
{
		extend : 'Ext.window.Window',
		alias : 'widget.adhocmesagingreportformwindow',			
		modal : true,		
		autoScroll:true,
		resizable:false,
		height:(Ext.isIE8)?700:'75%',
		width:(Ext.isIE8)?600:'55%',
		title:getMessagingModuleTranslation('ADD_DOCUMENT_ATTACHMENT'), //Add Document Attachment		
		initComponent: function() {
	        var this$ = this;	        
	        var store = this$.buildStore();        	        
	        this$.items = [{
				 xtype: 'form',				         
		         itemId: 'adhocMessagingReportSearchform',		         
		         plugins: "formlabelrequired",    
		         items: [{
	             xtype: 'fieldcontainer',
	             defaults: {
	                 labelAlign: 'top',
	                 width: 226
	             },
	             items: [{
	                 xtype: 'customcombobox',
	                 name: 'configLevel',
	                 fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY'),
	                 itemId: 'adhoc_msg_doc_category',
	                 editable: false,
	                 allowBlank: false,
	                 displayField: 'value',
	                 valueField: 'name',
	                 queryMode: 'local',
	                 msgTarget: 'qtip',
	                 listeners: {
	                     render: function(combo) {
	                         var store = Ext.create('Academia.store.documentmanagement.DocumentCategorys');
	                         combo.bindStore(store);
	                     }
	                 }
	             }]
	         }, {
	             xtype: 'fieldcontainer',
	             itemId:'documentTemplateButtonContainer',
	             width: '100%',
	             style: {            
 		                marginTop: '15px'
 		         },
	             cls: 'windowBtnPos',
	             items: [{
	                 xtype: 'button',
	                 itemId: 'searchButtonId',
	                 text: getDocumentTranslation('SEARCH'),
	                 ui: 'CustomBtnSubmit',
	                 scale: CONSTANTS.BUTTONSIZE,
	                 formBind: true
	             }, {
	                 xtype: 'button',
	                 itemId: 'resetBtnId',
	                 text: getDocumentTranslation('RESET'),
	                 ui: 'CustomBtnCancel',
	                 scale: CONSTANTS.BUTTONSIZE
	             }]
	         }]
	       },{
			 xtype: 'form',				         
		     itemId: 'adhocMessagingReportform',		         		         
		     items: [{
	             xtype: 'fieldcontainer',		
	             itemId: 'adhocMessagingReportSelectorContainer',
		         	 style: {            
		                marginLeft: '-10px'
		             },
	             items: [{
	            	 xtype:'hidden',
	            	 name:'templateCount',
	            	 itemId:'templateCount'
	             },{
	                 xtype: 'itemselector',
	                 name: 'adhocMessagingReports',
	                 itemId: 'adhocMessagingReportSelector',
	                 store: store,
	                 valueField: 'id',
	                 displayField: 'templateName',
	                 width: 500,
	                 height: 200,            
	                 buttons: [ 'add', 'remove'],
	                 msgTarget: 'side',
	                 fromTitle: getMessagingModuleTranslation('AVALIABLE_DOCUMENTS'), //Avaliable Documents
	                 toTitle: getMessagingModuleTranslation('SELECTED_DOCUMENTS'),    //Selected Documents        
	             }]
	         },{
	             xtype: 'fieldcontainer',
	         	 width:'100%',		
	             items: [{
	                 xtype: 'button',
	                 text: getMessagingModuleTranslation('ATTACH'), //Attach
	                 itemId: 'adhocMessagingReportAttachBtn',		                 
	                 ui: 'CustomBtnSubmit',
	                 scale: CONSTANTS.BUTTONSIZE
	             }, {
	                 xtype: 'button',
	                 text: getCommonTranslation('CANCEL'),
	                 ui: 'CustomBtnCancel',
	                 itemId: 'adhocMessagingReportCancelBtn',
	                 scale: CONSTANTS.BUTTONSIZE
	             }]
	         }]
	}];
	this$.callParent(arguments);        
},
buildStore: function() {
    return Ext.create('Academia.store.messaging.AdhocMessagingDocumentList');
}    		
});
