/**
 * @author pratahmesh.sheth
 *  
 * This is used to show adhoc message Configuration details tab panel
 * 
 */
Ext.define('Academia.view.messaging.AdhocMessageSubTabPanel', {
    extend: 'Ext.tab.Panel',
    alias: 'widget.adhocmessagesubtabpanel',
    plain: true,
    autoScroll: false,
//    hidden:true,
    layout: 'fit',
    border: true,    
    activeTab: 2,
    style : {
    	marginLeft : '16px'
    },
    items: [{
        xtype: 'genratetemplateform',
        title: getMessagingModuleTranslation('SETUP'),
        itemId: 'adhocSetupTab',
        closable: false,
        border: false,
        hidden : true,
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        }
    },{
        xtype: 'systemeventconfigmessagescopes',
        title: getMessagingModuleTranslation('MESSAGE_SCOPE'),
        itemId: 'adhocMessageScopesTab',
        closable: false,
        hidden : true,
        border: false,
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        }
    }, {
        xtype: 'adhocdistributionlist',
        title: getMessagingModuleTranslation('DISTRIBUTION_LIST'),
        itemId: 'adhocDistributionListForm',
        closable: false,
        border: false,        
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        }
    },{        
        title: getMessagingModuleTranslation('DYNAMIC_DOCUMENT_ATTACHMENT'), //Dynamic document attachment
        itemId: 'adhocReportTab',
        closable: false,        
        border: false,
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        },
    	items:[{
    		xtype: 'adhocmessagingreportpanel',
    		itemId:'adhocMessagingReportGrid',
    		maxHeight:300
    	}]
    },{
        xtype: 'adhocattachmentspanel',
        title: getMessagingModuleTranslation('ATTACHMENTS'),
        itemId: 'adhocAttachmentTab',
        closable: false,
        hidden : true,
        border: false,
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        }
    },{
        xtype: 'adhocreviewpanel',
        title: getMessagingModuleTranslation('REVIEW'),
        itemId: 'adhocReviewTab',
        closable: false,
        hidden : true,
        border: false,
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        }
    },{
        //xtype: 'templatereportform',
        title: getMessagingModuleTranslation('ADHOC'),
        itemId: 'adhocTab',
        closable: false,
        hidden : true,
        border: false,
        cls: 'panelNoSpace',
        bodyStyle: {
            overflow: 'auto !important'
        }
    }]
});