/**
 * @author prathamesh.sheth
 * 
 * This is the System event configuration basic information form 
 *   
 * */
Ext.define('Academia.view.messaging.SystemEventConfigBasicInfoForm',{
	extend:'Ext.form.Panel',
	alias:'widget.systemeventconfigbasicinfoform',
	autoScroll:false,
	frame: true,
	plugins : "formlabelrequired",
	items:[{    	    
		xtype:'hidden',
		name:'msgConfigLevelId',
		itemId:'msgConfigLevelId'	
	},{    	    
		xtype:'hidden',
		name:'msgConfigLevelValue',
		itemId:'msgConfigLevelValue'	
	},{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('SYSTEM_MESSAGE_EVENT'),                            
            editable: false,
//            store:'messaging.SystemEventMessageStore',
            name: 'systemMsgEventId',
            itemId: 'systemMessageEventCombo',
            valueField: 'id',
            //queryMode: 'local',
            displayField: 'displayCode',
            allowBlank: false,
            listeners: {
            	render: function(combo){
            		var store = Ext.create('Academia.store.messaging.SystemEventMessageStore');
            		combo.bindStore(store);
            	}
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('ACADEMY_LOCATION'),
            hidden:true,
            store: 'organization.academylocations.ActiveAcademyLocationStore',
            editable: false,
            name: 'academyLocationId',
            itemId: 'academyLocationCombo',
            valueField: 'id',                
            displayField: 'value',
            //queryMode: 'local',
            allowBlank: false
        },{
			xtype : 'textfield',
			name : 'uiDisplayCode',
			itemId:'uiDisplayCodeItemId',
			fieldLabel : getCommonTranslation("DISPLAY_NAME"),
			allowBlank:false,
			maxLength: 255
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('SELECT_TEMPLATE'),
            hidden:true,
            editable: false,
            name: 'msgTemplateConfigId',
            itemId: 'templateCombo',
            valueField: 'id',
            queryMode: 'local',
            displayField: 'code',
//            store:'messaging.MessageTemplate',
            allowBlank: false,
            listeners: {
            	render: function(combo){
            		var store = Ext.create('Academia.store.messaging.MessageTemplate');
            		combo.bindStore(store);
            	}
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('SELECT_SENDING_PRIORITY'),            
            store: 'messaging.SendingPriorityStore',
            editable: false,
            name: 'sendingPriority',
            itemId: 'sendingPriorityCombo',
            valueField: 'name',                
            displayField: 'value',
            hidden:true,
            disabled:true,
            queryMode: 'local',
            allowBlank: false
        }]    	
	}]
});
