/**
 * 
 * This component is used for to show Academy Location Details Dialog Box 
 */
Ext.define('Academia.view.organization.academylocations.AcademyLocationFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.academylocationformwindow',
    modal: true,
    autoScroll : true,
    height : 600,
    //resizable: false,
    title: getCommonTranslation('ACADEMY_LOCATION_DETAILS'), //'Academy Location Details'						
    items: [{
        xtype: 'idgeneratorformwin',
        itemId: 'academyLocationForm', 
        //method: 'POST',
        //margin: 0,
        //bodyPadding: '10 10 10 10',
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        //standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'academy_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            itemId: 'versionId_hidden_field',
            name: 'version'
        }, {
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 226
        	},
        	items: [{
                xtype: 'customcombobox',
                name: 'academy',
                fieldLabel: getCommonTranslation('LIST_OF_ACADEMIES'), //Academy
                itemId: 'academy_name',
                //store: 'organization.academylocations.AcademyStore',
                store:'organization.academylocations.AcademySmartSearchStore',
                valueField: 'id',
                displayField: 'value',
                //editable: false,
                //queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false,
                queryParam:'name',
    			//width: 460,
//    			triggerAction: '',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            }, {
                xtype: 'customcombobox',
                name: 'location',
                itemId: 'academy_location',
                fieldLabel: getCommonTranslation('LOCATION'), //Location
                //store: 'organization.academylocations.LocationStore',
                store:'organization.academylocations.LocationSmartSearchStore',
                valueField: 'id',
                displayField: 'value',
                //editable: false,
                //queryMode: 'local',
                //triggerAction: '',
                forceSelection: true,
                allowBlank: false,
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false,
                queryParam:'name',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            }]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 226
        	},
        	items: [{
        		xtype: 'textfield',
        		name: 'displayName',
        		itemId: 'academyLocationDisplayName',
        		fieldLabel: getCommonTranslation('DISPLAY_NAME'),
        		allowBlank: false,
        		width: 226
        	}, {
        		xtype: 'customcombobox',
        		name: 'ownership',
        		itemId: 'ownership',
        		fieldLabel: getCommonTranslation('OWNERSHIP'), //Ownership
        		store: 'organization.academylocations.OwnershipStore',
        		valueField : 'id',
        		displayField : 'value',
        		allowBlank: false,
        		typeAhead:true,
        		hidden:true
        	},{
        		xtype: 'customcombobox',
        		name: 'terminology',
        		itemId: 'terminology',
        		fieldLabel: getCommonTranslation('TERMINOLOGY'),
        		store: 'common.TerminologyStore',
        		displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
	            typeAhead:true,
        		allowBlank: false
        	}]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 250,
        	},
        	items: [{
                xtype:'panel',
                cls : 'panelNoSpace',
                items:[{
        		xtype: 'textfield',
        		name: 'displayNameOL',
        		itemId: 'displayNameOL',
        		fieldLabel: getCommonTranslation('DISPLAY_NAME_IN_OTHER_LANGUAGE'),
        		maxLength: 255,
        		labelAlign: 'top',
                width: 226
        	}]
        	}, {
                xtype:'panel',
                cls : 'panelNoSpace',
                items:[{
    				xtype: 'multiselectcombofield',
    				 cls:'multiBrandCampusCls',
    				name: 'campus',
    				itemId:'campus',
    				valueField: 'id',
    	            displayField: 'value',
    	            cls:'commonAutoHeightMultiselectField',
    				fieldLabel: getCommonTranslation('CAMPUS'),
    				store:'organization.academylocations.ListOfCampusStore',
    				allowBlank: true,
    				labelAlign: 'top',
    				typeAhead : true,
    			    hidden : true ,
    			    width: 226
            	}]
        	}]
        },{
        	xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },/* uncomment to show date and time location
            items: [{
                xtype: 'label',
                text: getCommonTranslation('CURRENT_DATE_ACADEMY_LOCATION'), //Current Date for Academy Location
                padding: '8 8 8 0'
            }, {
                xtype: 'label',
                padding: '8 8 8 0'
            }]------------*/
            
        }, /*-data change email and notification--*/{
        	xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            /*defaults: {
                padding: 3
            },*/
            items: [{
                xtype: 'label',
                text: getCommonTranslation('DATA_CHANGE_NOTIFICATION'), //Data Change Notification
                margin: '8 0 5 0',
                	 hidden:true
            }, {
                xtype: 'checkboxfield',
                boxLabel: getCommonTranslation('EMAIL'), //e-Mail
                name: 'isEmail',
                itemId: 'chkEmailBox',
                margin:'0 5 0 5',
                hidden:true
                	
                	
            }, {
                xtype: 'checkboxfield',
                boxLabel: getCommonTranslation('SMS'), //SMS
                name: 'isSMS',
                itemId: 'chkSMSBox',
                hidden:true
            }]
        },/*-mobile integration--*/{
        	xtype: 'checkboxfield',
        	name: 'mobileEnable',
        	boxLabel: getCommonTranslation('MOBILE_INTEGRATION_ENABLE'),
        	itemId:'mobileEnable',
        	inputValue : true,
        	uncheckedValue: false,
        	hidden:true
        },{
            xtype: 'checkboxfield',
            boxLabel: getCommonTranslation('SHOW_THUMBNAILS_LIST_LIVW'), //Show thumbnails images in list view
            name: 'isThumbnailsImage',
            itemId: 'chkThumbnailBox',
            disabled: true,
            hidden:true
        },{  xtype : 'displayfield',
      	  name : 'displayEntryExit',
    	  value : '<b class="menu-title">'
    		  +getCommonTranslation('LATITUDE')
    		  + '</b>',
    		  style : {
    			  textDecoration : "underline"
    		  }},{
           /*xtype: 'fieldset',
            title: getCommonTranslation('ACADEMY_LOCATION_SYSTEM_SETTINGS'), //Academy-Location System Settings
            collapsible: true,
            
            defaults: {
                labelAlign: 'top'
            },*/

        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 226
        	},
        	items: [{
        		fieldLabel: getCommonTranslation('IMPORT_FILE_LOC'), //Import File Location
        		xtype: 'textfield',
        		name: 'txtImportLoc',
        		itemId: 'txtImportLoc',
        		labelWidth: '50%',
        		disabled: true,
        		 hidden:true
        	}, {
        		fieldLabel: getCommonTranslation('EXPORT_FILE_LOC'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'txtExportLoc',
        		name: 'txtExportLoc',
        		labelWidth: '50%',
        		disabled: true,
        		 hidden:true

        	},{
        		fieldLabel: getCommonTranslation('DEGREE'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'latdegree',
        		name: 'latdegree',
        		width: 110,
        		maxLength: 10
        		

        	},{
        		fieldLabel: getCommonTranslation('MINUTE'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'latminute',
        		name: 'latminute',
        		width: 110,
        		maxLength: 10

        	},{
        		fieldLabel: getCommonTranslation('SECONDS'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'latseconds',
        		name: 'latseconds',
        		width: 110,
        		maxLength: 10
        	},{
        		fieldLabel: getCommonTranslation('DIRECTIONS'), //Export File Location
        		xtype: 'customcombobox',
        		itemId: 'latdirections',
        		store: 'common.LatitudeDirectionStore',
        		name: 'latdirections',
        		width: 110,
        		displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
	            typeAhead:true,
        		//allowBlank: false,
        		maxLength: 10

        	}]
        },  {
    		xtype: 'fieldcontainer',
    		layout: {
    		type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
        		width: 226
        	},
        items : [ {
    		
	        	  xtype : 'displayfield',
	        	  name : 'displayEntryExit',
	        	  value : '<b class="menu-title">'
	        		  + getCommonTranslation('LONGITUDE')
	        		  + '</b>',
	        		  style : {
	        			  textDecoration : "underline"
	        		  }
	          }]
        	}, {
    		xtype: 'fieldcontainer',
    		layout: {
    		type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
        		width: 226
        	},
        	
        	items: [{
        		fieldLabel: getCommonTranslation('DEGREE'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'longdegree',
        		name: 'longdegree',
        		width: 110,
        		maxLength: 10

        	},{
        		fieldLabel: getCommonTranslation('MINUTE'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'longminute',
        		name: 'longminute',
        		width: 110,
        		maxLength: 10
        		//disabled: true

        	},{
        		fieldLabel: getCommonTranslation('SECONDS'), //Export File Location
        		xtype: 'textfield',
        		itemId: 'longseconds',
        		name: 'longseconds',
        		width: 110,
        		maxLength: 10
        		//disabled: true

        	},{
        		fieldLabel: getCommonTranslation('DIRECTIONS'), //Export File Location
        		xtype: 'customcombobox',
        		itemId: 'longdirections',
        		name: 'longdirections',
        		width: 110,	
        		store: 'common.LongitudeDirectionStore',
        		maxLength: 10,
        		displayField:'value',
                valueField:'id',
               // forceSelection:true,
                editable:false,
	            typeAhead:true,
        		//allowBlank: false
        		//maxLength: 10

        	}]
        }, {
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
        		width: 226
        	},
        	items: [{
        		xtype : 'customcombobox',
        		fieldLabel: getCommonTranslation('DEFAULT_COUNTRY'),
        		hiddenName : 'cmbDefCountry',
        		name: 'cmbDefCountry',
        		itemId: 'cmbDefCountry',
        		store:'common.CountryStore',
        		valueField : 'id',
        		displayField : 'countryName',
        		//editable : false,
        		//valueNotFoundText:"",     
    			queryParam:'countryName',   		        						
				forceSelection :true,
				typeAhead : false,
				minChars:3,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				hideTrigger:false,
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryName}'  +
		                    '</div>';
		                }
		            }
        	},
        	{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('BASECURRENCY'),
                itemId: 'currency',
                name: 'currency',
               // allowBlank: false,
                store: 'organization.BaseCurrencyStore',
                //store: 'othermasters.currencymaster.CurrencyMasterStore',
                //forceSelection: true,
                editable: false,
                displayField: 'name',
                valueField: 'id'
}
        	
        	
        	/*{
        		xtype: 'customcombobox',
        		name: 'cmbDefCountry',
        		itemId: 'cmbDefCountry',
        		fieldLabel: getCommonTranslation('DEFAULT_COUNTRY'), //Default Country
        		store: 'common.CountryStore',
        		valueField: 'id',
        		displayField: 'countryName',
        		editable: false,
        		queryMode: 'local',
        		triggerAction: 'all',
        		forceSelection: true,
        		disabled: true,
        		
        	}*/]
        },{
    		xtype: 'checkboxfield',
    		width: 'auto',
    		labelAlign: 'right',
    		boxLabel: getCommonTranslation('PUBLISH_IN_CATALOGUE'),
    		name: 'whetherPublicCatalogue',
    		itemId: 'whetherPublicCatalogueId',
    		inputValue : true,
    		uncheckedValue: false

    	}, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveAcademyLocationForm',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelAcademyLocationForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});