/**
 * @author Akshay.Kalbhor
 * 
 * This component is used for to show Academy Location Details Grid
 */
Ext.define('Academia.view.organization.academylocations.AcademyLocationLinkGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.academylocationlinkgrid',
    //requires: ['Academia.view.organization.academylocations.AcademyLocationFormWindow'],
    store: 'organization.academylocations.AcademyLocationLinksStore',
    title: getCommonTranslation('ACADEMY_LOCATION_LINKS'), //Academy-Location Links
    collapsible: false,
    border: true,
    cls:'centerAlignTitle parallelGridCenterAlignTitle',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'academylocation':1
		}
	},
    columns: [{
        header: getCommonTranslation('ACADEMY_NAME'), //Academy Name	
        dataIndex: 'academyName',
        sortable: true,
        flex: .6
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION_NAME'), //Location Name
        dataIndex: 'locationName',
        sortable: true,
        flex: .4
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'), //Delete
        glyph: ICONGLYPH.DELETEGLYPH
        //text : getCommonTranslation('DELETE')
    },{
        xtype: 'button',
        //itemId: 'btnMoreOperations',
        //tooltip: getCommonTranslation('MORE_OPERATIONS'), //Add
        //text: getCommonTranslation('MORE_OPERATIONS'),
        /*menu: Ext.menu.Menu({
            items: [{*/
                text: getCommonTranslation('UPLOAD_LOGO'),
                itemId: 'uploadLogo' 
            /*}]
        })*/
    },{
    	xtype: 'button',
    	text: getCommonTranslation('ALA_ADD_ADDRESS'),
    	itemId: 'addAddressItemId' 
    },{
    	xtype: 'button',
    	text: getCommonTranslation('ADD_OTHER_INFORMATION'),
    	itemId: 'addOtherInfo' 
    }],

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'organization.academylocations.AcademyLocationLinksStore',
            emptyMsg: getCommonTranslation('EMPTY_ACADEMY_LOCATION_MESSAGE'),
            displayInfo: true
        }]
    }],
    showAcademyLocationForm: function() {
        var winAcademyLocationForm = Ext.widget('academylocationformwindow');
        winAcademyLocationForm.show();
        winAcademyLocationForm.down("#terminology").setValue('COLLEGE');
    }
});