/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.organization.academylocations.AcademyLocationPurposeDocumentGrid', {
	extend: 'Ext.window.Window',
	alias : 'widget.academylocationpurposedocumentgrid',
	border: true,
	modal : true,
	title: getProgramandcourseTranslation('DOWNLOAD_DOCUMENT'),
	autoScroll: true,
	maxHeight: '20%',
	width: '30%',
	items:[{
		xtype: 'form',
		plugins:"formlabelrequired",
		items: [{
			xtype: 'grid',
			itemId:'academylocationpurposedocumentgridId',
			border:true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			store : 'organization.academylocations.AcademyLocationPurposeDocument',
			tbar: [{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),
				glyph: ICONGLYPH.DELETEGLYPH		
			}],
			columns :[{
				header : getCommonTranslation('DOCMENT_NAME'),
				dataIndex : 'documentName',
				flex:1,
				renderer:function(value){
					if(!isNullOrEmpty(value)){
						return '<a href="#">'+value+'</a>';
					}else{
						return null;
					}
				}
			}]
		}]
	}]
});


