/*
 * View of the statutory accounting which contains the tree structure.
 * @Author Akshay.Kalbhor
 */
var group = this.id + '-ddgroup';
Ext.define('Academia.view.organization.managementaccounting.ManagementAccountingTree', {
    extend: 'Ext.tree.TreePanel',
    alias: 'widget.mgmtacctree',
    title: getCommonTranslation('TREETITLE'),
    store: Ext.create('Academia.store.organization.StructureTreeStore'),
    autoShow: false,
    height: 300,
    frame:true,
    //useArrows: true,
    //border: true,
    /*
     * UI Class for the tree without the icons
     */
    cls: 'no-tree-icon',
    rootVisible: true,
    multiSelect: false,
    singleExpand: true,
    viewConfig: {
        plugins: {
            ptype: 'treeviewdragdrop',
            ddGroup: group,
            appendOnly: true,
            sortOnDrop: true,
            containerScroll: true
        },
        listeners: {
            beforedrop: function(node, data, overModel, dropPosition, dropHandlers) {
        	/**
        	 * @event 
        	 * Firing an application level event when element is dragged on(actually before dropping it) 
        	 * which is listened on the controller ManagementAccounting.js.
        	 * @param {Ext.Component} node
        	 * @param {Object} data
        	 * @param {Object} overModel
        	 * @param {Object} dropPosition
        	 * @param {Object} dropHandlers
        	 */
        	this.fireEvent('managementAccTreeDrag', node, data, overModel, dropPosition, dropHandlers);
            }
        }
    },

    tbar: {
    	items: [{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('ADD'),
    	    itemId: 'btnAdd',
    	    iconCls:'icon-addbutton',
			cls:'addbutton'
    	},{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('EDIT'),
    	    itemId: 'btnEdit',
    	    iconCls:'icon-editbutton',
			cls:'editbutton'
    	},{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('VIEW'),
    	    itemId: 'btnView',
    	    iconCls: 'icon-View',
			cls:'iconView'
    	},{
    	    xtype : 'splitbutton',
    	    itemId:'spBtnMoreActionsma',
    	    text : getCommonTranslation('MOREACTIONS'),
    	    menu:[{
    	    	text:getCommonTranslation('VIEWLINKEDALP'),
    	    	itemId:'viewLinkedALPma'
    	    }],
    	    listeners: { click: function() { this.showMenu(); } }
    	}]
    }

});