var group1 = this.id + '-ddgroup';
Ext.define('Academia.view.organization.supervision.SupervisoryTreeStructure', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.supervisorytreeStructure',
    title: getCommonTranslation('SUPERVISIONTITLE'),
    store: Ext.create('Academia.store.organization.StructureTreeStore'),
    controller: 'organization.Supervision',
    itemId : 'supervisorytreeStructure',
    height: 300,
    border: true,
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    // Class for the tree without the icons on it
    cls: 'no-tree-icon',
    rootVisible: true,
    singleExpand: true,
    viewConfig: {
        plugins: {
            ptype: 'treeviewdragdrop',
            ddGroup: group1,
            appendOnly: true,
            sortOnDrop: true,
            containerScroll: true
        },
        listeners: {
            beforedrop: function(node, data, overModel, dropPosition, dropHandlers) {
        	/**
        	 * @event 
        	 * Firing an application level event when element is dragged on(actually before dropping it) 
        	 * which is listened on the controller Supervision.js.
        	 * @param {Ext.Component} node
        	 * @param {Object} data
        	 * @param {Object} overModel
        	 * @param {Object} dropPosition
        	 * @param {Object} dropHandlers
        	 */
        	this.fireEvent('supervisionTreeDrag', node, data, overModel, dropPosition, dropHandlers);
            }
        }
    },
    tbar: {
    	items: [{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('ADD'),
    	    itemId: 'btnAdd',
    	    iconCls:'icon-addbutton',
			 cls:'addbutton' 		// taken from the commonConstants.
    	},{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('EDIT'),
    	    itemId: 'btnEdit',
    	    iconCls:'icon-editbutton',
			cls:'editbutton'		// taken from the commonConstants.
    	},{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('VIEW'),
    	    itemId: 'btnView',
    	    iconCls: 'icon-View',
			cls:'iconView'		// taken from the commonConstants.
    	},{
    	    xtype : 'splitbutton',
    	    itemId:'spBtnMoreActions',
    	    text : getCommonTranslation('MOREACTIONS'),
    	    menu:[{
	    		text:getCommonTranslation('VIEWLINKEDALP'),
	    		itemId:'viewLinkedALP'
    	    }],
    	    listeners: {
    	    	click: function() {
        	    	this.showMenu();
    	    	}
    	    }
    	}]
    }

});