/**
 * @author trupti.paoneker
 * 
 * This component is used for to show contact person details in form  
 */
Ext.define('Academia.view.othermasters.bankmaster.AddNewContactPersonFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.contactpersonformwindow',
    title: getCommonTranslation('CONTACT_PERSON_DETAILS'),
    modal: true,
    items: [{
        xtype: 'form',
        itemId: 'addbankContactform',
        method: 'POST',
        standardSubmit: false,
        plugins: "formlabelrequired",
        autoScroll: true,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'hidden',
            name: 'contactPersonId',
            itemId: 'AddContact_hiddenfield'
        }, {
            xtype: 'hidden',
            name: 'bankId',
            itemId: 'Outer_hidden'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'textfield',
                name: 'personName',
                fieldLabel: getCommonTranslation('NAME'), //Name
                maxLength: 20,
                 //Enter Name
                allowBlank: false
            }, {
                xtype: 'textfield',
                name: 'designation',
                maxLength: 25,
                fieldLabel: getCommonTranslation('DESIGNATION'), //Designation
                 //Enter Designation
                allowBlank: false
            }]
        }, {
            xtype: 'textareafield',
            fieldLabel: getCommonTranslation('ADDRESS'),
            maxLength: 200,
            name: 'addressText',
            allowBlank: false,
            width: 460
        }, {
            xtype: 'fieldcontainer',
            itemId: 'countryContainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
                //hiddenName: 'country',
                itemId: 'country',
                
                store: 'common.CountryStore',
                valueField: 'id',
                displayField: 'countryName',
                name: 'country',
                editable: false,
                valueNotFoundText: "",
                forceSelection: true,
                allowBlank: false,
                queryMode: 'local'
            }, {
                xtype: 'nestedJsonCombo',
                overrideSetValue: false,
                fieldLabel: getCommonTranslation('ADDRESS_CITY'),
                hiddenName: 'city',
                itemId: 'cityId',
                
                store: 'organization.CityStore',
                valueField: 'id',
                displayField: 'cityName',
                name: 'city',
                editable: false,
                valueNotFoundText: "",
                forceSelection: true,
                allowBlank: false,
                queryMode: 'local'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'nestedJsonCombo',
                overrideSetValue: false,
                fieldLabel: getCommonTranslation('ADDRESS_Generic_Field_1'),
                hiddenName: 'genericField1',
                itemId: 'genericFieldId1',
                store: 'organization.CountryRegionStore',
                valueField: 'id',
                displayField: 'countryRegionName',
                triggerAction: 'all',
                name: 'parentCountryRegion',
                editable: false,
                valueNotFoundText: "",
                forceSelection: true,
                allowBlank: false,
                queryMode: 'local'
            }, {
                xtype: 'nestedJsonCombo',
                overrideSetValue: false,
                fieldLabel: getCommonTranslation('ADDRESS_Generic_Field_2'),
                hiddenName: 'genericField2',
                itemId: 'genericFieldId2',
                store: 'organization.CountryRegionStore1',
                valueField: 'id',
                displayField: 'countryRegionName',
                name: 'countryRegion',
                triggerAction: 'all',
                editable: false,
                valueNotFoundText: "",
                forceSelection: true,
                //queryMode: 'local'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),
            allowBlank: false,
            layout: {
                type: 'hbox'
            },
            defaults: {
                enforceMaxLength: true,
                labelAlign: 'top',
                width: 226
                //cls:'inputInRow'
            },
            items: [{
                xtype: 'customcombobox',
                hiddenName: 'phoneNumber1',
                
                valueField: 'isdCode',
                displayField: 'isdCode',
                store: 'common.CountryStore',
                //queryMode: 'local',
                triggerAction: 'all',
                name: 'phoneCountryCode',
                itemId: 'phoneCountryCode',
                editable: false,
                width: 108
            }, {
                xtype: 'numberfield',
                name: 'code',
                
                name: 'phoneAreaCode',
                width: 108,
                maxLength: 5,
                // To Remove spinner buttons, and arrow key and mouse wheel listeners
                hideTrigger: true,
                keyNavEnabled: false,
                mouseWheelEnabled: false
            }, {
                xtype: 'numberfield',
                itemId: 'phoneNoField',
                name: 'phoneNo',
                maxLength: 10,
                // To Remove spinner buttons, and arrow key and mouse wheel listeners
                hideTrigger: true,
                keyNavEnabled: false,
                mouseWheelEnabled: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            allowBlank: false,
            fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
            defaults: {
                enforceMaxLength: true,
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'cellCountryCode',
                itemId: 'cellCountryCode',
                
                valueField: 'isdCode',
                displayField: 'isdCode',
                store: 'common.CountryStore',
                //  queryMode: 'local',
                triggerAction: 'all',
                editable: false,
                width: 108
            }, {
                xtype: 'numberfield',
                name: 'cellNo',
				minLength: 6,
				maxLength: 11,
                allowBlank: false,
                // To Remove spinner buttons, and arrow key and mouse wheel listeners
                hideTrigger: true,
                keyNavEnabled: false,
                mouseWheelEnabled: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
                name: 'primaryeEmailId',
                
                vtype: 'email',
                allowBlank: false
            }, {
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
                name: 'alternateEmailId',
                
                vtype: 'email',
                allowBlank: true
            }]
        }, {
            xtype: 'fieldcontainer',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveContactForm',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelContactForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});