/**
 * @author Amit G
 
 * This component is used for to show associate invoice master grid details.
 */
Ext.define('Academia.view.othermasters.currencymaster.AssociateInvoiceCurrencyMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.associateinvoicecurrencymastergrid',
    store: 'othermasters.currencymaster.AssociateInvoiceCurrencyMasterGridStore',
    title: getCommonTranslation('LIST_OF_CURRENCY_ASSOCIATE_WITH_RECEIPT'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.currencymaster.AssociateInvoiceCurrencyMasterGridStore',
            emptyMsg: getCommonTranslation('NO_CURRENCY_TO_DISPLAY'), //No currency to display
            displayInfo: true
        }]
    }],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    columns: [{
        header: getCommonTranslation('INVOICE_CURRENCY'),
        dataIndex: 'invoiceCurrencyName',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('RECEIPT_CURRENCY'),
        dataIndex: 'receiptCurrencyNames',
        sortable: false,
        flex: .2
    }]
});