/**
 * @author Trupti.Paoneker
 
 * This component is used for to show deficit credit master grid details.
 */
Ext.define('Academia.view.othermasters.deficitmaster.DeficitCreditMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.deficitmastergrid',
    store: 'othermasters.deficitmaster.DeficitCreditMasterStore',
    title: getCommonTranslation('DEFICIT_CREDIT_MASTER'), //Deficit Credit Master
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('GRADE_TYPE'), //Grade Type	
        dataIndex: 'grade',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'code');
        }
    }, {
        header: getCommonTranslation('EVAL_GRADE'), //Eval Grade
        dataIndex: 'gradesGroup',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'code');
        }
    }, {
        header: getCommonTranslation('COURSE_NAME'), //Course Name
        dataIndex: 'course',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }

    }, {
        header: getCommonTranslation('DEFICIT_POINTS'), //Deficit Credit Points
        dataIndex: 'deficitPoints',
        sortable: false,
        flex: .2
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), 
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), 
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), 
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.deficitmaster.DeficitCreditMasterStore',
            emptyMsg:'<span id="manageAccountingGridId" style="margin-top: 60px !important">'+  getCommonTranslation('NO_DEFICIT_MASTER_TO_DISPLAY')+'</span>', //No deficit points to display
            displayInfo: true
        }]
    }]
});