/**
 * This form is used for student and faculty attendance details
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.course.AttendanceQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.attendancequicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'attendanceProgram',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_PROGRAM'),
            editable: false,
            allowBlank: false,
            valueField: 'programId',
            displayField: 'programName',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.placementrequest.PlacementPrograms');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchCombo',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            //allowBlank: false,
            editable: false,
            fieldLabel: getCommonTranslation('BATCH'),
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'period',
            itemId: 'period',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_PERIOD'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    //var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                	var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'course',
            itemId: 'course',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_COURSE'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.coursereading.CourseByPeriod');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'courseComponent',
            itemId: 'courseComponent',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_COURSE_COMPONENT'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.course.coursetopic.CourseComponentStore');
                    combo.bindStore(store);
                }
            }
        }]

    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
          //--submitFormat: 'Y-m-d',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_FROMDATE'),
            emptyText: getPersonModuleTranslation('ATTENDANCE_FROMDATE'),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
          //--submitFormat: 'Y-m-d',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_TODATE'),
            emptyText: getPersonModuleTranslation('ATTENDANCE_TODATE'),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'attendanceSearchButtonId',
            ui: 'CustomBtnSubmit',
            formBind: true,
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});