/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.personinfo.common.course.FacultyProgramAssociatedDetailsGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.facultyprogramassociateddetailsgrid',
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   
    columns: [{
        header: getPersonModuleTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable:true,
        flex: 1
    },{
        header: getPersonModuleTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable:true,
        flex: 1
    },{
        header: getPersonModuleTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
        flex: 1
    }],
    
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        //this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.FacultyAssociatedprogramStore');
    }

});