/**
 * @author Sachin.Bangar
 * This is used to show pop up of person details
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.PersonWindowSu', {
    extend: 'Ext.window.Window',
    alias: 'widget.personwindowsu',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    width: 890,
    maxHeight : 550,
    // BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    }
    // END SCROLL-SAVING WORKAROUND CODE
});
